/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.formatters;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.util.ArrayList;
import java.util.HashMap;

public class CompactStatsFormatter {
    public static ArrayList<String> formatStats(HashMap<String, String> stats) {
        ArrayList<String> output = new ArrayList<String>();
        String df = BridgeDuelsStatsMod.settings.getstatprefixcolour();
        if (stats.get("Error") != null) {
            output.add(stats.get("Error"));
        } else {
            output.add(stats.get("formattedname") + df + " Lvl: " + CompactStatsFormatter.formatNetworkLevel(stats.get("networklvl")) + df + ", AP: " + CompactStatsFormatter.formatAchievementPoints(stats.get("achievementPoints")) + df + ", " + CompactStatsFormatter.formatOnlineStatus(stats.get("onlinestatus")));
        }
        return output;
    }

    private static String formatOnlineStatus(String status) {
        boolean onlineStatus = Boolean.parseBoolean(status);
        if (onlineStatus) {
            return ChatFormatting.GREEN + "Online";
        }
        return ChatFormatting.RED + "Offline";
    }

    private static String formatAchievementPoints(String achievementPoints) {
        long ap = Long.parseLong(achievementPoints);
        String line = "";
        if (ap < 250L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (ap < 500L) {
            line = line + ChatFormatting.GRAY;
        } else if (ap < 750L) {
            line = line + ChatFormatting.WHITE;
        } else if (ap < 1000L) {
            line = line + ChatFormatting.GOLD;
        } else if (ap < 2000L) {
            line = line + ChatFormatting.AQUA;
        } else if (ap < 3000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (ap < 4000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (ap < 5000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (ap >= 5000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + achievementPoints;
        return line;
    }

    public static String formatNetworkLevel(String networklvl) {
        long lvl = Long.parseLong(networklvl);
        String line = "";
        if (lvl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (lvl < 1000L) {
            line = line + ChatFormatting.GRAY;
        } else if (lvl < 2500L) {
            line = line + ChatFormatting.WHITE;
        } else if (lvl < 5000L) {
            line = line + ChatFormatting.GOLD;
        } else if (lvl < 10000L) {
            line = line + ChatFormatting.AQUA;
        } else if (lvl < 15000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (lvl < 20000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (lvl < 25000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (lvl >= 25000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + networklvl;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }
}

