/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.formatters;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.util.ArrayList;
import java.util.HashMap;

public class SimpleStatsFormatter {
    public static ArrayList<String> formatStats(HashMap<String, String> stats) {
        ArrayList<String> output = new ArrayList<String>();
        String df = BridgeDuelsStatsMod.settings.getstatprefixcolour();
        if (stats.get("Error") != null) {
            output.add(stats.get("Error"));
        } else {
            output.add(stats.get("formattedname") + df + " Lvl: " + SimpleStatsFormatter.formatNetworkLevel(stats.get("networklvl")) + df + ", AP: " + SimpleStatsFormatter.formatAchievementPoints(stats.get("achievementPoints")));
            output.add(SimpleStatsFormatter.formatOnlineStatus(stats.get("onlinestatus")) + df + " for " + SimpleStatsFormatter.formatTimeColor(stats.get("time"), stats.get("onlinestatus")) + stats.get("formattedtime") + df + ", last played: " + SimpleStatsFormatter.formatLastPlayed(stats.get("lastplayed")));
        }
        return output;
    }

    private static String formatLastPlayed(String lastplayed) {
        if (lastplayed == null) {
            return ChatFormatting.BLACK + "null";
        }
        lastplayed = lastplayed.toLowerCase();
        lastplayed = lastplayed.replaceAll("_", " ");
        lastplayed = lastplayed.replaceAll("-", " ");
        boolean h = true;
        for (int i = 0; i < lastplayed.length(); ++i) {
            if ("qwertyuiopasdfghjklzxcvbnm".contains(lastplayed.substring(i, i + 1))) {
                if (h) {
                    lastplayed = lastplayed.substring(0, i) + lastplayed.substring(i, i + 1).toUpperCase() + lastplayed.substring(i + 1);
                }
                h = false;
                continue;
            }
            if (!lastplayed.substring(i, i + 1).equals(" ")) continue;
            h = true;
        }
        return ChatFormatting.WHITE + lastplayed;
    }

    private static String formatTimeColor(String t, String status) {
        long time = Long.parseLong(t);
        String line = "";
        if (Boolean.parseBoolean(status)) {
            if (time < 120L) {
                line = line + ChatFormatting.RED;
            } else if (time < 300L) {
                line = line + ChatFormatting.GOLD;
            } else if (time < 600L) {
                line = line + ChatFormatting.YELLOW;
            } else if (time < 1200L) {
                line = line + ChatFormatting.GREEN;
            } else if (time < 3600L) {
                line = line + ChatFormatting.DARK_GREEN;
            } else if (time < 7200L) {
                line = line + ChatFormatting.DARK_BLUE;
            } else if (time < 28800L) {
                line = line + ChatFormatting.DARK_PURPLE;
            } else if (time < 86400L) {
                line = line + ChatFormatting.DARK_RED;
            } else if (time >= 86400L) {
                line = line + ChatFormatting.BLACK;
            }
            return line;
        }
        if (time < 300L) {
            line = line + ChatFormatting.RED;
        } else if (time < 900L) {
            line = line + ChatFormatting.GOLD;
        } else if (time < 3600L) {
            line = line + ChatFormatting.YELLOW;
        } else if (time < 21600L) {
            line = line + ChatFormatting.GREEN;
        } else if (time < 86400L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (time < 604800L) {
            line = line + ChatFormatting.DARK_BLUE;
        } else if (time < 2419200L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (time < 31536000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (time >= 31536000L) {
            line = line + ChatFormatting.BLACK;
        }
        return line;
    }

    private static String formatOnlineStatus(String status) {
        boolean onlineStatus = Boolean.parseBoolean(status);
        if (onlineStatus) {
            return ChatFormatting.GREEN + "Online";
        }
        return ChatFormatting.RED + "Offline";
    }

    private static String formatAchievementPoints(String achievementPoints) {
        long ap = Long.parseLong(achievementPoints);
        String line = "";
        if (ap < 250L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (ap < 500L) {
            line = line + ChatFormatting.GRAY;
        } else if (ap < 750L) {
            line = line + ChatFormatting.WHITE;
        } else if (ap < 1000L) {
            line = line + ChatFormatting.GOLD;
        } else if (ap < 2000L) {
            line = line + ChatFormatting.AQUA;
        } else if (ap < 3000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (ap < 4000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (ap < 5000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (ap >= 5000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + achievementPoints;
        return line;
    }

    public static String formatNetworkLevel(String networklvl) {
        long lvl = Long.parseLong(networklvl);
        String line = "";
        if (lvl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (lvl < 1000L) {
            line = line + ChatFormatting.GRAY;
        } else if (lvl < 2500L) {
            line = line + ChatFormatting.WHITE;
        } else if (lvl < 5000L) {
            line = line + ChatFormatting.GOLD;
        } else if (lvl < 10000L) {
            line = line + ChatFormatting.AQUA;
        } else if (lvl < 15000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (lvl < 20000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (lvl < 25000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (lvl >= 25000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + networklvl;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }
}

