/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.formatters.bedwars;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.util.ArrayList;
import java.util.HashMap;

public class SimpleBedwarsStatsFormatter {
    public static ArrayList<String> formatStats(HashMap<String, String> stats, String mode) {
        ArrayList<String> output = new ArrayList<String>();
        String df = BridgeDuelsStatsMod.settings.getstatprefixcolour();
        if (stats.get("Error") != null) {
            output.add(stats.get("Error"));
        } else {
            String stars = SimpleBedwarsStatsFormatter.formatStars(stats.get("bedwarsstar"));
            String wins = SimpleBedwarsStatsFormatter.formatWins(stats.get("bedwars" + mode + "wins"));
            String wlr = SimpleBedwarsStatsFormatter.formatWinLoss(stats.get("bedwars" + mode + "wlr"));
            String fkdr = SimpleBedwarsStatsFormatter.formatFKDR(stats.get("bedwars" + mode + "fkdr"));
            String bblr = SimpleBedwarsStatsFormatter.formatBBLR(stats.get("bedwars" + mode + "bblr"));
            String ws = SimpleBedwarsStatsFormatter.formatWinstreak(stats.get("bedwars" + mode + "ws"));
            output.add(stats.get("formattedname") + df + " Stars: " + stars + df + ", Wins: " + wins);
            output.add(df + "W/L: " + wlr + df + ", FKDR: " + fkdr + df + ", BBLR: " + bblr + df + ", WS: " + ws);
        }
        return output;
    }

    private static String formatFKDR(String killdeath) {
        if (killdeath.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long kd = Long.parseLong(killdeath);
        String line = "";
        if (kd == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (kd < 100L) {
            line = line + ChatFormatting.GRAY;
        } else if (kd < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (kd < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (kd < 800L) {
            line = line + ChatFormatting.AQUA;
        } else if (kd < 1500L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (kd >= 1500L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + killdeath;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatBBLR(String bedratio) {
        if (bedratio.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long bblr = Long.parseLong(bedratio);
        String line = "";
        if (bblr == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (bblr < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (bblr < 100L) {
            line = line + ChatFormatting.WHITE;
        } else if (bblr < 250L) {
            line = line + ChatFormatting.GOLD;
        } else if (bblr < 500L) {
            line = line + ChatFormatting.AQUA;
        } else if (bblr < 1000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (bblr >= 1000L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + bedratio;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatWinstreak(String winstreak) {
        long ws = Long.parseLong(winstreak);
        String line = "";
        if (ws == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (ws < 10L) {
            line = line + ChatFormatting.GRAY;
        } else if (ws < 25L) {
            line = line + ChatFormatting.WHITE;
        } else if (ws < 50L) {
            line = line + ChatFormatting.GOLD;
        } else if (ws < 100L) {
            line = line + ChatFormatting.AQUA;
        } else if (ws < 250L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (ws >= 250L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winstreak;
        return line;
    }

    private static String formatWinLoss(String winloss) {
        if (winloss.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long wl = Long.parseLong(winloss);
        String line = "";
        if (wl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (wl < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (wl < 100L) {
            line = line + ChatFormatting.WHITE;
        } else if (wl < 250L) {
            line = line + ChatFormatting.GOLD;
        } else if (wl < 500L) {
            line = line + ChatFormatting.AQUA;
        } else if (wl < 1000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (wl >= 1000L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winloss;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatWins(String wins) {
        long w = Long.parseLong(wins);
        String line = "";
        if (w == 0L) {
            line = line + ChatFormatting.BLACK;
        } else if (w < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (w < 100L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (w < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (w < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (w < 1000L) {
            line = line + ChatFormatting.AQUA;
        } else if (w < 2000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (w < 5000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (w < 10000L) {
            line = line + ChatFormatting.YELLOW;
        } else if (w >= 10000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        }
        line = line + wins;
        return line;
    }

    public static String formatStars(String stars) {
        long lvl = Long.parseLong(stars);
        String line = "";
        if (lvl < 5000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("DARK_GRAY");
        } else if (lvl < 10000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("GRAY");
        } else if (lvl < 20000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("WHITE");
        } else if (lvl < 30000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("GOLD");
        } else if (lvl < 40000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("AQUA");
        } else if (lvl < 50000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("DARK_GREEN");
        } else if (lvl < 60000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("DARK_AQUA");
        } else if (lvl < 70000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("DARK_RED");
        } else if (lvl < 80000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("LIGHT_PURPLE");
        } else if (lvl < 90000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("BLUE");
        } else if (lvl < 100000L) {
            line = line + SimpleBedwarsStatsFormatter.s2c("DARK_PURPLE");
        } else if (lvl >= 100000L) {
            line = line + stars;
            line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2) + "\u272d";
            for (int i = line.length() - 1; i >= 0; --i) {
                String[] colours = new String[]{SimpleBedwarsStatsFormatter.s2c("RED"), SimpleBedwarsStatsFormatter.s2c("GOLD"), SimpleBedwarsStatsFormatter.s2c("YELLOW"), SimpleBedwarsStatsFormatter.s2c("GREEN"), SimpleBedwarsStatsFormatter.s2c("AQUA"), SimpleBedwarsStatsFormatter.s2c("BLUE"), SimpleBedwarsStatsFormatter.s2c("DARK_PURPLE"), SimpleBedwarsStatsFormatter.s2c("LIGHT_PURPLE")};
                line = line.substring(0, i) + colours[i] + line.substring(i);
            }
            return line;
        }
        line = line + stars;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2) + "\u272d";
        return line;
    }

    private static String s2c(String s) {
        if (s.equals("DARK_GREEN")) {
            return "" + ChatFormatting.DARK_GREEN;
        }
        if (s.equals("DARK_RED")) {
            return "" + ChatFormatting.DARK_RED;
        }
        if (s.equals("DARK_BLUE")) {
            return "" + ChatFormatting.DARK_BLUE;
        }
        if (s.equals("DARK_GRAY")) {
            return "" + ChatFormatting.DARK_GRAY;
        }
        if (s.equals("DARK_AQUA")) {
            return "" + ChatFormatting.DARK_AQUA;
        }
        if (s.equals("DARK_PURPLE")) {
            return "" + ChatFormatting.DARK_PURPLE;
        }
        if (s.equals("GOLD")) {
            return "" + ChatFormatting.GOLD;
        }
        if (s.equals("GRAY")) {
            return "" + ChatFormatting.GRAY;
        }
        if (s.equals("WHITE")) {
            return "" + ChatFormatting.WHITE;
        }
        if (s.equals("RED")) {
            return "" + ChatFormatting.RED;
        }
        if (s.equals("AQUA")) {
            return "" + ChatFormatting.AQUA;
        }
        if (s.equals("LIGHT_PURPLE")) {
            return "" + ChatFormatting.LIGHT_PURPLE;
        }
        if (s.equals("YELLOW")) {
            return "" + ChatFormatting.YELLOW;
        }
        if (s.equals("GREEN")) {
            return "" + ChatFormatting.GREEN;
        }
        if (s.equals("BLUE")) {
            return "" + ChatFormatting.BLUE;
        }
        if (s.equals("BLACK")) {
            return "" + ChatFormatting.BLACK;
        }
        if (s.equals("BOLD")) {
            return "" + ChatFormatting.BOLD;
        }
        if (s.equals("OBFUSCATED")) {
            return "" + ChatFormatting.OBFUSCATED;
        }
        if (s.equals("ITALIC")) {
            return "" + ChatFormatting.ITALIC;
        }
        if (s.equals("RESET")) {
            return "" + ChatFormatting.RESET;
        }
        return "" + ChatFormatting.GRAY;
    }
}

