/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.settings;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class Settings {
    private String API_KEY;
    private String masscheckmode;
    private String singlecheckmode;
    private String spc;
    private String statprefixcolour;
    private File config;

    public Settings() {
        this.config = new File(BridgeDuelsStatsMod.getMinecraft().field_71412_D.getAbsolutePath() + "\\config\\bdsm.cfg");
        this.API_KEY = "";
        this.singlecheckmode = "normal";
        this.masscheckmode = "normal";
        this.spc = "white";
        this.statprefixcolour = Settings.s2c(this.spc);
        boolean isNew = false;
        try {
            isNew = this.config.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: Unknown error while creating config file.");
            return;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            System.out.println("Error: Unknown error while creating config file.");
            return;
        }
        if (isNew) {
            this.writeSettingsToFile();
        } else {
            try {
                this.readFromFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error: Unknown error while reading config file.");
                BridgeDuelsStatsMod.warn("Error: Unknown error while reading config file.");
            }
        }
    }

    public void readFromFile() throws IOException {
        System.out.println("reading");
        BufferedReader in = new BufferedReader(new FileReader(this.config));
        String line = in.readLine();
        while (line != null) {
            if (line.equals("") || line.startsWith("#") || line.indexOf("=") < 1) {
                line = in.readLine();
                continue;
            }
            int i = line.indexOf("=");
            if (i == -1) {
                return;
            }
            String key = line.substring(0, i);
            ++i;
            if (key.equals("API_KEY")) {
                this.API_KEY = line.substring(i);
            } else if (key.equals("masscheckmode")) {
                this.masscheckmode = line.substring(i).equalsIgnoreCase("compact") ? "compact" : "normal";
            } else if (key.equals("singlecheckmode")) {
                this.singlecheckmode = line.substring(i).equalsIgnoreCase("compact") ? "compact" : "normal";
            } else if (key.equals("statprefixcolour")) {
                this.spc = line.substring(i).toLowerCase();
                this.statprefixcolour = Settings.s2c(this.spc);
                if (this.statprefixcolour.equals("")) {
                    this.spc = "white";
                    this.statprefixcolour = Settings.s2c(this.spc);
                }
            }
            line = in.readLine();
        }
        in.close();
    }

    public void setAPIKey(String key) {
        this.API_KEY = key;
        this.writeSettingsToFile();
    }

    public String getAPIKey() {
        return this.API_KEY;
    }

    public void setmasscheckmode(String mode) {
        this.masscheckmode = mode;
        this.writeSettingsToFile();
    }

    public String getmasscheckmode() {
        return this.masscheckmode;
    }

    public void setsinglecheckmode(String mode) {
        this.singlecheckmode = mode;
        this.writeSettingsToFile();
    }

    public String getsinglecheckmode() {
        return this.singlecheckmode;
    }

    public boolean setstatprefixcolour(String colour) {
        String s = Settings.s2c(colour);
        if (!s.equals("")) {
            this.spc = colour.toLowerCase();
            this.statprefixcolour = Settings.s2c(this.spc);
            this.writeSettingsToFile();
            return true;
        }
        return false;
    }

    public String getstatprefixcolour() {
        return this.statprefixcolour;
    }

    public String getspc() {
        return this.spc;
    }

    public ArrayList<String> generateArrayList() {
        ArrayList<String> output = new ArrayList<String>();
        output.add("#API Key used to access Hypixel API (Don't touch, update this in-game using /api new on hypixel)");
        output.add("API_KEY=" + this.API_KEY);
        output.add("");
        output.add("#How comprehensive information sent to chat is when multiple players' stats are checked in one command.");
        output.add("#Can be normal or compact, defaults to normal");
        output.add("masscheckmode=" + this.masscheckmode);
        output.add("");
        output.add("#How comprehensive information sent to chat is when a single player's stats are checked in one command.");
        output.add("#Can be normal or compact, defaults to normal");
        output.add("singlecheckmode=" + this.singlecheckmode);
        output.add("");
        output.add("#The default colour for player stat prefixes, e.g. FKDR, Star, Kills, K/D, etc.");
        output.add("#Can be any of the standard chatformatting options:");
        output.add("#dark_red, red, gold, yellow, green, dark_green, aqua, dark_aqua, blue,\n#dark_blue, dark_purple, light_purple, gray, dark_gray, black, or white.");
        output.add("statprefixcolour=" + this.spc);
        output.add("");
        return output;
    }

    public void writeSettingsToFile() {
        try {
            this.config.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config.getParentFile().mkdir();
            try {
                this.config.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                BridgeDuelsStatsMod.getMinecraft().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(Settings.fixColour("" + ChatFormatting.DARK_RED, "Could not create config file.")));
            }
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(this.config);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            BridgeDuelsStatsMod.getMinecraft().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(Settings.fixColour("" + ChatFormatting.DARK_RED, "Could not write settings to config file.")));
        }
        ArrayList<String> arr = this.generateArrayList();
        for (String s : arr) {
            out.println(s);
        }
        out.close();
    }

    private static String fixColour(String colour, String line) {
        int i = line.indexOf(" ");
        while (i >= 0) {
            line = line.substring(0, i + 1) + colour + line.substring(i + 1);
            i = line.indexOf(" ", i + 1);
        }
        return colour + line;
    }

    private static String c2s(String s) {
        if ((s = s.toLowerCase()).equals("" + ChatFormatting.DARK_GREEN)) {
            return "dark_green";
        }
        if (s.equals("" + ChatFormatting.DARK_RED)) {
            return "dark_red";
        }
        if (s.equals("" + ChatFormatting.DARK_BLUE)) {
            return "dark_blue";
        }
        if (s.equals("" + ChatFormatting.DARK_GRAY)) {
            return "dark_gray";
        }
        if (s.equals("" + ChatFormatting.DARK_AQUA)) {
            return "dark_aqua";
        }
        if (s.equals("" + ChatFormatting.DARK_PURPLE)) {
            return "dark_purple";
        }
        if (s.equals("" + ChatFormatting.GOLD)) {
            return "gold";
        }
        if (s.equals("" + ChatFormatting.GRAY)) {
            return "gray";
        }
        if (s.equals("" + ChatFormatting.WHITE)) {
            return "white";
        }
        if (s.equals("" + ChatFormatting.RED)) {
            return "red";
        }
        if (s.equals("" + ChatFormatting.AQUA)) {
            return "aqua";
        }
        if (s.equals("" + ChatFormatting.LIGHT_PURPLE)) {
            return "light_purple";
        }
        if (s.equals("" + ChatFormatting.YELLOW)) {
            return "yellow";
        }
        if (s.equals("" + ChatFormatting.GREEN)) {
            return "green";
        }
        if (s.equals("" + ChatFormatting.BLUE)) {
            return "blue";
        }
        if (s.equals("" + ChatFormatting.BLACK)) {
            return "black";
        }
        return "null";
    }

    private static String s2c(String s) {
        if ((s = s.toLowerCase()).equals("dark_green")) {
            return "" + ChatFormatting.DARK_GREEN;
        }
        if (s.equals("dark_red")) {
            return "" + ChatFormatting.DARK_RED;
        }
        if (s.equals("dark_blue")) {
            return "" + ChatFormatting.DARK_BLUE;
        }
        if (s.equals("dark_gray")) {
            return "" + ChatFormatting.DARK_GRAY;
        }
        if (s.equals("dark_aqua")) {
            return "" + ChatFormatting.DARK_AQUA;
        }
        if (s.equals("dark_purple")) {
            return "" + ChatFormatting.DARK_PURPLE;
        }
        if (s.equals("gold")) {
            return "" + ChatFormatting.GOLD;
        }
        if (s.equals("gray")) {
            return "" + ChatFormatting.GRAY;
        }
        if (s.equals("white")) {
            return "" + ChatFormatting.WHITE;
        }
        if (s.equals("red")) {
            return "" + ChatFormatting.RED;
        }
        if (s.equals("aqua")) {
            return "" + ChatFormatting.AQUA;
        }
        if (s.equals("light_purple")) {
            return "" + ChatFormatting.LIGHT_PURPLE;
        }
        if (s.equals("yellow")) {
            return "" + ChatFormatting.YELLOW;
        }
        if (s.equals("green")) {
            return "" + ChatFormatting.GREEN;
        }
        if (s.equals("blue")) {
            return "" + ChatFormatting.BLUE;
        }
        if (s.equals("black")) {
            return "" + ChatFormatting.BLACK;
        }
        return "";
    }
}

