/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.stats;

import com.google.gson.JsonElement;
import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import daniel.bridgeduelsstatsmod.formatters.CompactStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.SimpleStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.bedwars.CompactBedwarsStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.bedwars.SimpleBedwarsStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.bridge.CompactBridgeStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.bridge.SimpleBridgeStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.duels.CompactDuelsStatsFormatter;
import daniel.bridgeduelsstatsmod.formatters.duels.SimpleDuelsStatsFormatter;
import daniel.bridgeduelsstatsmod.printers.StatsPrinter;
import daniel.bridgeduelsstatsmod.stats.PStats;
import daniel.bridgeduelsstatsmod.stats.StatsGetter;
import daniel.bridgeduelsstatsmod.stats.UUIDCache;
import daniel.bridgeduelsstatsmod.stats.organizers.StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwars1StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwars2StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwars3StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwars4StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwars4v4StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bedwars.SimpleBedwarsStatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridge1StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridge2StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridge2sStatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridge3sStatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridge4StatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.bridge.SimpleBridgeStatsOrganizer;
import daniel.bridgeduelsstatsmod.stats.organizers.duels.SimpleDuelsStatsOrganizer;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class StatsChecker {
    public static void showStats(final String[] args) {
        args[0] = args[0].toLowerCase();
        if (!StatsChecker.checkModeExists(args[0])) {
            BridgeDuelsStatsMod.getMinecraft().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(ChatFormatting.RED + "Error, mode " + args[0] + " does not exist."));
            return;
        }
        final ArrayList out = new ArrayList();
        new Thread(new Runnable(){

            @Override
            public void run() {
                StatsChecker.sendMessage(ChatFormatting.BLUE + "---------------" + ChatFormatting.WHITE + "Checking..." + ChatFormatting.RED + "---------------");
                StatsChecker.sendMessage(StatsChecker.modeGetter(args[0]));
                Thread[] threads = new Thread[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    final int tempi = i;
                    threads[i - 1] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block3: {
                                try {
                                    JsonElement player = StatsGetter.getPlayer(args[tempi], BridgeDuelsStatsMod.settings.getAPIKey());
                                    UUIDCache.addToCache(player, args[tempi]);
                                    HashMap<String, String> statSet = StatsChecker.checkForMode(args[0], player);
                                    ArrayList<String> lines = args.length > 2 ? StatsChecker.formatForMode(args[0], statSet, BridgeDuelsStatsMod.settings.getmasscheckmode()) : StatsChecker.formatForMode(args[0], statSet, BridgeDuelsStatsMod.settings.getsinglecheckmode());
                                    out.add(new PStats(args[tempi], lines));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    if (e.getMessage().contains("HTTP response code: 429")) {
                                        StatsChecker.sendMessage(StatsChecker.fixColour("" + ChatFormatting.RED, "You have hit the plancke API rate limit, please slow down."));
                                    }
                                    if (!e.getMessage().contains("HTTP response code: 403")) break block3;
                                    StatsChecker.sendMessage(StatsChecker.fixColour("" + ChatFormatting.RED, "Incorrect API key, please run \"/api new\" on Hypixel."));
                                }
                            }
                        }
                    });
                    threads[i - 1].start();
                }
                for (Thread t : threads) {
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                for (PStats output : out) {
                    StatsPrinter.printStats(output.getStats(), output.getName());
                }
                StatsChecker.sendMessage(ChatFormatting.BLUE + "---------------" + ChatFormatting.WHITE + "Check end" + ChatFormatting.RED + "---------------");
            }
        }).start();
    }

    public static boolean checkModeExists(String mode) {
        return BridgeDuelsStatsMod.modes.contains(mode.toLowerCase());
    }

    public static ArrayList<String> formatForMode(String mode, HashMap<String, String> statSet, String checkmode) {
        if ((mode = mode.toLowerCase()).equals("stats")) {
            if (checkmode.equals("normal")) {
                return SimpleStatsFormatter.formatStats(statSet);
            }
            if (checkmode.equals("compact")) {
                return CompactStatsFormatter.formatStats(statSet);
            }
        } else if (mode.endsWith("duel") || mode.endsWith("d")) {
            String fmode = mode.replaceAll("duel", "");
            if (fmode.equals(mode)) {
                fmode = fmode.substring(0, fmode.length() - 1);
            }
            if (fmode.equals("skywars")) {
                fmode = "sw";
            } else if (fmode.equals("megawalls")) {
                fmode = "mw";
            } else if (fmode.equals("pot")) {
                fmode = "potion";
            } else if (fmode.equals("bs")) {
                fmode = "bowspleef";
            }
            if (checkmode.equals("normal")) {
                return SimpleDuelsStatsFormatter.formatStats(statSet, fmode);
            }
            if (checkmode.equals("compact")) {
                return CompactDuelsStatsFormatter.formatStats(statSet, fmode);
            }
        } else if (mode.startsWith("bedwars") || mode.startsWith("bw")) {
            String fmode = mode.replaceAll("bedwars", "");
            fmode = fmode.replaceAll("bw", "");
            if (checkmode.equals("normal")) {
                return SimpleBedwarsStatsFormatter.formatStats(statSet, fmode);
            }
            if (checkmode.equals("compact")) {
                return CompactBedwarsStatsFormatter.formatStats(statSet, fmode);
            }
        } else if (mode.startsWith("bridge") || mode.startsWith("b")) {
            String fmode = mode.replaceAll("bridge", "");
            fmode = fmode.replaceAll("b", "");
            if (checkmode.equals("normal")) {
                return SimpleBridgeStatsFormatter.formatStats(statSet, fmode);
            }
            if (checkmode.equals("compact")) {
                return CompactBridgeStatsFormatter.formatStats(statSet, fmode);
            }
        }
        return null;
    }

    public static HashMap<String, String> checkForMode(String mode, JsonElement player) {
        if ((mode = mode.toLowerCase()).equals("stats")) {
            return StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge") || mode.equals("b")) {
            return SimpleBridgeStatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge1") || mode.equals("b1")) {
            return SimpleBridge1StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge2") || mode.equals("b2")) {
            return SimpleBridge2StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge4") || mode.equals("b4")) {
            return SimpleBridge4StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge2s") || mode.equals("b2s")) {
            return SimpleBridge2sStatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bridge3s") || mode.equals("b3s")) {
            return SimpleBridge3sStatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars") || mode.equals("bw")) {
            return SimpleBedwarsStatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars1") || mode.equals("bw1")) {
            return SimpleBedwars1StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars2") || mode.equals("bw2")) {
            return SimpleBedwars2StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars3") || mode.equals("bw3")) {
            return SimpleBedwars3StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars4") || mode.equals("bw4")) {
            return SimpleBedwars4StatsOrganizer.organizeStats(player);
        }
        if (mode.equals("bedwars4v4") || mode.equals("bw4v4")) {
            return SimpleBedwars4v4StatsOrganizer.organizeStats(player);
        }
        if (mode.endsWith("duel") || mode.endsWith("d")) {
            String fmode = mode.replaceAll("duel", "");
            if (fmode.equals(mode)) {
                fmode = fmode.substring(0, fmode.length() - 1);
            }
            return SimpleDuelsStatsOrganizer.organizeStats(player, fmode);
        }
        return null;
    }

    public static String modeGetter(String mode) {
        mode = mode.toLowerCase();
        String w = ChatFormatting.WHITE + "";
        String b = ChatFormatting.BLUE + "";
        String r = ChatFormatting.RED + "";
        if (mode.equals("stats")) {
            return b + "Checking " + w + "general" + r + " stats...";
        }
        if (mode.equals("bridge") || mode.equals("b")) {
            return b + "Checking " + w + "bridge overall" + r + " stats...";
        }
        if (mode.equals("bridge1") || mode.equals("b1")) {
            return b + "Checking " + w + "bridge 1v1" + r + " stats...";
        }
        if (mode.equals("bridge2") || mode.equals("b2")) {
            return b + "Checking " + w + "bridge 2v2" + r + " stats...";
        }
        if (mode.equals("bridge4") || mode.equals("b4")) {
            return b + "Checking " + w + "bridge 4v4" + r + " stats...";
        }
        if (mode.equals("bridge2s") || mode.equals("b2s")) {
            return b + "Checking " + w + "bridge 2v2v2v2" + r + " stats...";
        }
        if (mode.equals("bridge3s") || mode.equals("b3s")) {
            return b + "Checking " + w + "bridge 3v3v3v3" + r + " stats...";
        }
        if (mode.equals("bedwars") || mode.equals("bw")) {
            return b + "Checking " + w + "bedwars" + r + " stats...";
        }
        if (mode.equals("bedwars1") || mode.equals("bw1")) {
            return b + "Checking " + w + "bedwars solo" + r + " stats...";
        }
        if (mode.equals("bedwars2") || mode.equals("bw2")) {
            return b + "Checking " + w + "bedwars doubles" + r + " stats...";
        }
        if (mode.equals("bedwars3") || mode.equals("bw3")) {
            return b + "Checking " + w + "bedwars 3s" + r + " stats...";
        }
        if (mode.equals("bedwars4") || mode.equals("bw4")) {
            return b + "Checking " + w + "bedwars 4s" + r + " stats...";
        }
        if (mode.equals("bedwars4v4") || mode.equals("bw4v4")) {
            return b + "Checking " + w + "bedwars 4v4" + r + " stats...";
        }
        if (mode.endsWith("duel") || mode.endsWith("d")) {
            String fmode = mode.replaceAll("duel", "");
            if (fmode.equals(mode)) {
                fmode = fmode.substring(0, fmode.length() - 1);
            }
            if (fmode.equals("sw")) {
                fmode = "skywars";
            } else if (fmode.equals("mw")) {
                fmode = "megawalls";
            } else if (fmode.equals("pot")) {
                fmode = "potion";
            } else if (fmode.equals("bs")) {
                fmode = "bowspleef";
            }
            fmode = fmode + " duel";
            return b + "Checking " + w + fmode + r + " stats...";
        }
        return null;
    }

    private static void sendMessage(String s) {
        BridgeDuelsStatsMod.getMinecraft().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(s));
    }

    private static String fixColour(String colour, String line) {
        int i = line.indexOf(" ");
        while (i >= 0) {
            line = line.substring(0, i + 1) + colour + line.substring(i + 1);
            i = line.indexOf(" ", i + 1);
        }
        return colour + line;
    }
}

