/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.stats.organizers.bedwars;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;

public class SimpleBedwars4v4StatsOrganizer {
    public static HashMap<String, String> organizeStats(JsonElement player) {
        HashMap<String, String> initial = new HashMap<String, String>();
        String error = "";
        if (player.isJsonObject()) {
            if (((JsonObject)player).get("success").getAsBoolean()) {
                if (((JsonObject)player).get("player").isJsonNull()) {
                    error = error + "No such player. ";
                } else {
                    JsonObject playerinfo = null;
                    try {
                        playerinfo = ((JsonObject)player).get("player").getAsJsonObject();
                    }
                    catch (Exception e) {
                        initial.put("Error", initial.get("Error") + "Player info doesn't exist. ");
                    }
                    String[] checks = new String[]{"displayname", "prefix", "monthlyPackageRank", "packageRank", "newPackageRank", "rank", "rankPlusColor", "networkExp"};
                    String[] bedwarschecks = new String[]{"Experience", "two_four_wins_bedwars", "two_four_losses_bedwars", "two_four_final_kills_bedwars", "two_four_final_deaths_bedwars", "two_four_beds_broken_bedwars", "two_four_beds_lost_bedwars", "two_four_winstreak"};
                    for (String check : checks) {
                        String result = null;
                        try {
                            result = playerinfo.get(check).getAsString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initial.put(check, result);
                    }
                    JsonObject playerstats = null;
                    try {
                        playerstats = playerinfo.get("stats").getAsJsonObject();
                    }
                    catch (Exception e) {
                        error = error + "Player stats doesn't exist. ";
                    }
                    JsonObject bedwarsinfo = null;
                    try {
                        bedwarsinfo = playerstats.get("Bedwars").getAsJsonObject();
                    }
                    catch (Exception e) {
                        error = error + "Bedwars info doesn't exist. ";
                    }
                    for (String bedwarscheck : bedwarschecks) {
                        String result = null;
                        try {
                            result = bedwarsinfo.get(bedwarscheck).getAsString();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initial.put(bedwarscheck, result);
                    }
                }
            } else {
                error = error + "Unsuccessful check.";
            }
        }
        if (!error.equals("")) {
            initial.put("Error", error);
            return initial;
        }
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("formattedname", SimpleBedwars4v4StatsOrganizer.getFormattedName(initial));
        output.put("networklvl", SimpleBedwars4v4StatsOrganizer.getNWLvl(initial));
        output.put("bedwarsstar", SimpleBedwars4v4StatsOrganizer.star2str(SimpleBedwars4v4StatsOrganizer.getBedWarsLevel(Double.parseDouble(SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("Experience"))))));
        output.put("bedwars4v4wins", SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_wins_bedwars")));
        output.put("bedwars4v4wlr", SimpleBedwars4v4StatsOrganizer.getRatio(SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_wins_bedwars")), SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_losses_bedwars"))));
        output.put("bedwars4v4fkdr", SimpleBedwars4v4StatsOrganizer.getRatio(SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_final_kills_bedwars")), SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_final_deaths_bedwars"))));
        output.put("bedwars4v4bblr", SimpleBedwars4v4StatsOrganizer.getRatio(SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_beds_broken_bedwars")), SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_beds_lost_bedwars"))));
        output.put("bedwars4v4ws", SimpleBedwars4v4StatsOrganizer.formatNull(initial.get("two_four_winstreak")));
        return output;
    }

    public static String star2str(double star) {
        long x = (long)(star * 100.0);
        String s = String.valueOf(x);
        if (s.length() == 1) {
            return "00" + s;
        }
        if (s.length() == 2) {
            return "0" + s;
        }
        return s;
    }

    private static double getBedWarsLevel(double exp) {
        int level = 100 * (int)(exp / 487000.0);
        if ((exp %= 487000.0) < 500.0) {
            return (double)level + exp / 500.0;
        }
        ++level;
        if (exp < 1500.0) {
            return (double)level + (exp - 500.0) / 1000.0;
        }
        ++level;
        if (exp < 3500.0) {
            return (double)level + (exp - 1500.0) / 2000.0;
        }
        ++level;
        if (exp < 7000.0) {
            return (double)level + (exp - 3500.0) / 3500.0;
        }
        return (double)(++level) + (exp -= 7000.0) / 5000.0;
    }

    private static String getRatio(String wins, String losses) {
        if (wins.equals("0")) {
            return "000";
        }
        if (losses.equals("0")) {
            return "NaN";
        }
        String s = String.valueOf(Long.parseLong(wins) * 100L / Long.parseLong(losses));
        if (s.length() == 1) {
            return "00" + s;
        }
        if (s.length() == 2) {
            return "0" + s;
        }
        return s;
    }

    private static String getNWLvl(HashMap<String, String> stats) {
        String s = stats.get("networkExp");
        long totalExp = s == null ? 0L : (s.indexOf("E") > -1 ? (long)(Double.parseDouble(s.substring(0, s.indexOf("E"))) * Math.pow(10.0, Double.parseDouble(s.substring(s.indexOf("E") + 1)))) : (long)Double.parseDouble(s));
        return SimpleBedwars4v4StatsOrganizer.getNWLevel(totalExp) + SimpleBedwars4v4StatsOrganizer.getPercentageToNextLevel(totalExp);
    }

    private static String getNWLevel(long exp) {
        return exp <= 0L ? "1" : String.valueOf((long)Math.floor(-2.5 + Math.sqrt(12.25 + 8.0E-4 * (double)exp)));
    }

    private static long totalExpToLevel(long level) {
        long x0 = SimpleBedwars4v4StatsOrganizer.getTotalExpToFullLevel(level);
        return (SimpleBedwars4v4StatsOrganizer.getTotalExpToFullLevel(level + 1L) - x0) * (level % 1L) + x0;
    }

    private static long getTotalExpToFullLevel(long level) {
        return (1250L * (level - 2L) + 10000L) * (level - 1L);
    }

    private static String getPercentageToNextLevel(long exp) {
        long lv = Long.parseLong(SimpleBedwars4v4StatsOrganizer.getNWLevel(exp));
        long x0 = SimpleBedwars4v4StatsOrganizer.totalExpToLevel(lv);
        String out = String.valueOf((long)(((double)exp - (double)x0) / ((double)SimpleBedwars4v4StatsOrganizer.totalExpToLevel(lv + 1L) - (double)x0) * 100.0));
        if (out.length() < 2) {
            out = "0" + out;
        }
        return out;
    }

    private static String getFormattedName(HashMap<String, String> stats) {
        String df = ChatFormatting.WHITE + "";
        String formattedname = ChatFormatting.GRAY + "";
        String rank = "";
        if (stats.get("prefix") != null) {
            String prefix = stats.get("prefix");
            while (prefix.indexOf("\u00c2\u00a7") != -1) {
                int index = prefix.indexOf("\u00c2\u00a7");
                formattedname = formattedname + prefix.substring(0, index);
                switch (prefix.charAt(index + 2)) {
                    case 'c': {
                        formattedname = formattedname + ChatFormatting.RED;
                        break;
                    }
                    case 'b': {
                        formattedname = formattedname + ChatFormatting.AQUA;
                        break;
                    }
                    case 'd': {
                        formattedname = formattedname + ChatFormatting.LIGHT_PURPLE;
                        break;
                    }
                    case '3': {
                        formattedname = formattedname + ChatFormatting.DARK_AQUA;
                        break;
                    }
                    case '6': {
                        formattedname = formattedname + ChatFormatting.GOLD;
                        break;
                    }
                    default: {
                        formattedname = formattedname + df;
                    }
                }
                prefix = prefix.substring(index + 3);
            }
            formattedname = formattedname + prefix + " ";
        } else if (stats.get("rank") != null && !stats.get("rank").equals("NORMAL")) {
            rank = stats.get("rank");
        } else if (stats.get("monthlyPackageRank") != null && !stats.get("monthlyPackageRank").equals("NONE")) {
            rank = stats.get("monthlyPackageRank");
        } else if (stats.get("newPackageRank") != null && !stats.get("newPackageRank").equals("NONE")) {
            rank = stats.get("newPackageRank");
        } else if (stats.get("packageRank") != null && !stats.get("packageRank").equals("NONE")) {
            rank = stats.get("packageRank");
        }
        if (rank.equals("") && formattedname.equals(df)) {
            formattedname = formattedname + ChatFormatting.GRAY;
        } else if (rank.equals("ADMIN")) {
            formattedname = formattedname + ChatFormatting.RED;
            formattedname = formattedname + "[ADMIN] ";
        } else if (rank.equals("MODERATOR")) {
            formattedname = formattedname + ChatFormatting.DARK_GREEN;
            formattedname = formattedname + "[MOD] ";
        } else if (rank.equals("HELPER")) {
            formattedname = formattedname + ChatFormatting.BLUE;
            formattedname = formattedname + "[HELPER] ";
        } else if (rank.equals("YOUTUBER")) {
            formattedname = formattedname + ChatFormatting.RED;
            formattedname = formattedname + "[" + ChatFormatting.WHITE + "YOUTUBE" + ChatFormatting.RED + "] ";
        } else if (rank.equals("VIP")) {
            formattedname = formattedname + ChatFormatting.GREEN;
            formattedname = formattedname + "[VIP] ";
        } else if (rank.equals("VIP_PLUS")) {
            formattedname = formattedname + ChatFormatting.GREEN;
            formattedname = formattedname + "[VIP" + ChatFormatting.GOLD + "+" + ChatFormatting.GREEN + "] ";
        } else if (rank.equals("MVP")) {
            formattedname = formattedname + ChatFormatting.AQUA;
            formattedname = formattedname + "[MVP] ";
        } else if (rank.equals("MVP_PLUS")) {
            formattedname = formattedname + ChatFormatting.AQUA;
            formattedname = stats.get("rankPlusColor") != null ? formattedname + "[MVP" + SimpleBedwars4v4StatsOrganizer.s2c(stats.get("rankPlusColor")) + "+" + ChatFormatting.AQUA + "] " : formattedname + "[MVP" + SimpleBedwars4v4StatsOrganizer.s2c("RED") + "+" + ChatFormatting.AQUA + "] ";
        } else if (rank.equals("SUPERSTAR")) {
            formattedname = formattedname + ChatFormatting.GOLD;
            formattedname = stats.get("rankPlusColor") != null ? formattedname + "[MVP" + SimpleBedwars4v4StatsOrganizer.s2c(stats.get("rankPlusColor")) + "++" + ChatFormatting.GOLD + "] " : formattedname + "[MVP" + SimpleBedwars4v4StatsOrganizer.s2c("RED") + "++" + ChatFormatting.GOLD + "] ";
        }
        formattedname = formattedname + stats.get("displayname");
        return formattedname;
    }

    private static String s2c(String s) {
        if (s.equals("DARK_GREEN")) {
            return "" + ChatFormatting.DARK_GREEN;
        }
        if (s.equals("DARK_RED")) {
            return "" + ChatFormatting.DARK_RED;
        }
        if (s.equals("DARK_BLUE")) {
            return "" + ChatFormatting.DARK_BLUE;
        }
        if (s.equals("DARK_GRAY")) {
            return "" + ChatFormatting.DARK_GRAY;
        }
        if (s.equals("DARK_AQUA")) {
            return "" + ChatFormatting.DARK_AQUA;
        }
        if (s.equals("DARK_PURPLE")) {
            return "" + ChatFormatting.DARK_PURPLE;
        }
        if (s.equals("GOLD")) {
            return "" + ChatFormatting.GOLD;
        }
        if (s.equals("GRAY")) {
            return "" + ChatFormatting.GRAY;
        }
        if (s.equals("WHITE")) {
            return "" + ChatFormatting.WHITE;
        }
        if (s.equals("RED")) {
            return "" + ChatFormatting.RED;
        }
        if (s.equals("AQUA")) {
            return "" + ChatFormatting.AQUA;
        }
        if (s.equals("LIGHT_PURPLE")) {
            return "" + ChatFormatting.LIGHT_PURPLE;
        }
        if (s.equals("YELLOW")) {
            return "" + ChatFormatting.YELLOW;
        }
        if (s.equals("GREEN")) {
            return "" + ChatFormatting.GREEN;
        }
        if (s.equals("BLUE")) {
            return "" + ChatFormatting.BLUE;
        }
        if (s.equals("BLACK")) {
            return "" + ChatFormatting.BLACK;
        }
        if (s.equals("BOLD")) {
            return "" + ChatFormatting.BOLD;
        }
        if (s.equals("OBFUSCATED")) {
            return "" + ChatFormatting.OBFUSCATED;
        }
        if (s.equals("ITALIC")) {
            return "" + ChatFormatting.ITALIC;
        }
        if (s.equals("RESET")) {
            return "" + ChatFormatting.RESET;
        }
        return "" + ChatFormatting.GRAY;
    }

    private static String formatNull(String s) {
        if (s == null) {
            return "0";
        }
        return s;
    }
}

