/*
 * Decompiled with CFR 0.152.
 */
package com.kbrewster;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@Reference(apiName="API", apiVersion="1.1.2")
public abstract class API {
    private static String apiName = API.class.getAnnotation(Reference.class).apiName();
    private static String apiVersion = API.class.getAnnotation(Reference.class).apiVersion();
    private static OkHttpClient client = new OkHttpClient();

    protected static String sendGet(String url, String contentType) throws IOException {
        Request request = new Request.Builder().url(url).header("User-Agent", contentType).build();
        Response response = client.newCall(request).execute();
        return response.body().string();
    }

    protected static String sendGet(String url) throws IOException {
        return API.sendGet(url, "application/json");
    }

    protected static String sendPost(String url, String payload, String contentType) throws IOException {
        MediaType MEDIA_TYPE = MediaType.parse(contentType);
        RequestBody body = RequestBody.create(MEDIA_TYPE, payload);
        Request request = new Request.Builder().url(url).post(body).build();
        Response response = client.newCall(request).execute();
        return response.body().string();
    }

    protected static String sendPost(String url, String payload) throws IOException {
        return API.sendPost(url, payload, "application/json");
    }

    public static String getApiName() {
        return apiName;
    }

    public static String getApiVersion() {
        return apiVersion;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Reference {
        public String apiName();

        public String apiVersion();
    }
}

