/*
 * Decompiled with CFR 0.152.
 */
package com.kbrewster.hypixelapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kbrewster.API;
import com.kbrewster.exceptions.APIException;
import com.kbrewster.exceptions.InvalidGuildException;
import com.kbrewster.exceptions.InvalidPlayerException;
import com.kbrewster.hypixelapi.boosters.Booster;
import com.kbrewster.hypixelapi.friends.Friend;
import com.kbrewster.hypixelapi.guild.Guild;
import com.kbrewster.hypixelapi.key.APIKey;
import com.kbrewster.hypixelapi.leaderboards.Leaderboard;
import com.kbrewster.hypixelapi.leaderboards.Leaderboards;
import com.kbrewster.hypixelapi.player.HypixelPlayer;
import com.kbrewster.hypixelapi.session.Session;
import com.kbrewster.mojangapi.MojangAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@API.Reference(apiName="Hypixel API", apiVersion="1.1.2")
public class HypixelAPI
extends API {
    private final String BASE_URL = "https://api.hypixel.net";
    private final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36";
    private String key;

    public HypixelAPI(String key) {
        this.key = key;
    }

    public HypixelPlayer getPlayer(String name) throws APIException, InvalidPlayerException, IOException {
        Gson gson = new Gson();
        String url = String.format("https://api.hypixel.net/player?name=%s&key=%s", name, this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement player = json.get("player");
        if (player.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        return gson.fromJson(player, HypixelPlayer.class);
    }

    public HypixelPlayer getPlayerByUUID(String uuid) throws APIException, InvalidPlayerException, IOException {
        Gson gson = new Gson();
        String url = String.format("https://api.hypixel.net/player?uuid=%s&key=%s", uuid, this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement player = json.get("player");
        if (player.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        return gson.fromJson(player, HypixelPlayer.class);
    }

    public Session getSession(String name) throws APIException, IOException {
        String uuid = MojangAPI.getUUID(name);
        return this.getSessionByUUID(uuid);
    }

    public Session getSessionByUUID(String uuid) throws APIException, IOException {
        Gson gson = new Gson();
        String url = String.format("https://api.hypixel.net/session?uuid=%s&key=%s", uuid, this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement session = json.get("session");
        if (session.isJsonNull()) {
            throw new APIException("No session found!");
        }
        return gson.fromJson(session, Session.class);
    }

    public List<Friend> getFriends(String name) throws APIException, InvalidPlayerException, IOException {
        String uuid = MojangAPI.getUUID(name);
        return this.getFriendsByUUID(uuid);
    }

    public List<Friend> getFriendsByUUID(String uuid) throws APIException, InvalidPlayerException, IOException {
        Gson gson = new Gson();
        ArrayList<Friend> friends = new ArrayList<Friend>();
        String url = String.format("https://api.hypixel.net/friends?uuid=%s&key=%s", uuid, this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement records = json.get("records");
        if (records.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        records.getAsJsonArray().forEach(jsonElement -> friends.add(gson.fromJson((JsonElement)jsonElement, Friend.class)));
        return friends;
    }

    public List<Booster> getBoosters() throws APIException, IOException {
        Gson gson = new Gson();
        ArrayList<Booster> boosters = new ArrayList<Booster>();
        String url = String.format("https://api.hypixel.net/boosters?key=%s", this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement records = json.get("boosters");
        if (records.isJsonNull()) {
            throw new APIException("No boosters found!");
        }
        records.getAsJsonArray().forEach(jsonElement -> boosters.add(gson.fromJson((JsonElement)jsonElement, Booster.class)));
        return boosters;
    }

    public List<Leaderboard> getLeaderboard(Leaderboards leaderboard) throws APIException, IOException {
        Gson gson = new Gson();
        ArrayList<Leaderboard> leaderboards = new ArrayList<Leaderboard>();
        String url = String.format("https://api.hypixel.net/leaderboards?key=%s", this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonObject lb = json.getAsJsonObject("leaderboards");
        System.out.println(leaderboard.name());
        lb.getAsJsonArray(leaderboard.name()).forEach(element -> leaderboards.add(gson.fromJson((JsonElement)element, Leaderboard.class)));
        return leaderboards;
    }

    public String getGuildID(String name) throws IOException, APIException {
        String uuid = MojangAPI.getUUID(name);
        return this.getGuildIDByUUID(uuid);
    }

    public Guild getGuild(String guildID) throws IOException, APIException {
        Gson gson = new Gson();
        String url = String.format("https://api.hypixel.net/guild?key=%s&id=%s", this.key, guildID);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement guild = json.get("guild");
        if (guild.isJsonNull()) {
            throw new InvalidGuildException();
        }
        return gson.fromJson(guild, Guild.class);
    }

    public String getGuildIDByUUID(String uuid) throws IOException, APIException {
        String url = String.format("https://api.hypixel.net/findGuild?byUuid=%s&key=%s", uuid, this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        return json.get("guild").getAsString();
    }

    public APIKey getKeyInfo() throws IOException, APIException {
        Gson gson = new Gson();
        String url = String.format("https://api.hypixel.net/key?key=%s", this.key);
        JsonObject json = this.readJsonUrl(url);
        if (!json.get("success").getAsBoolean()) {
            throw new APIException(json.get("cause").getAsString());
        }
        JsonElement record = json.get("record");
        if (record.isJsonNull()) {
            throw new APIException("No record found!");
        }
        return gson.fromJson(record, APIKey.class);
    }

    private JsonObject readJsonUrl(String url) throws IOException {
        JsonElement jElement = new JsonParser().parse(HypixelAPI.sendGet(url, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36"));
        return jElement.getAsJsonObject();
    }
}

