/*
 * Decompiled with CFR 0.152.
 */
package me.djtheredstoner.perspectivemod;

import me.djtheredstoner.perspectivemod.ModCoreInstaller;
import me.djtheredstoner.perspectivemod.commands.PerspectiveModCommand;
import me.djtheredstoner.perspectivemod.config.PerspectiveModConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

@Mod(modid="djperspectivemod", name="Perspective Mod v4", version="4.2", acceptedMinecraftVersions="[1.8.9]", clientSideOnly=true)
public class PerspectiveMod {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final KeyBinding perspectiveKey = new KeyBinding("Perspective", 56, "Perspective Mod");
    private static final Logger logger = LogManager.getLogger((String)"Perspective Mod v4");
    public static PerspectiveModConfig config;
    public static boolean perspectiveToggled;
    public static float cameraYaw;
    public static float cameraPitch;
    private static int previousPerspective;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCoreInstaller.initializeModCore(Minecraft.func_71410_x().field_71412_D);
        config = new PerspectiveModConfig();
        config.preload();
        ClientRegistry.registerKeyBinding((KeyBinding)perspectiveKey);
        ClientCommandHandler.instance.func_71560_a((ICommand)new PerspectiveModCommand());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (perspectiveKey.func_151463_i() > 0) {
            PerspectiveMod.onPressed(Keyboard.getEventKey(), Keyboard.getEventKeyState());
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseInputEvent event) {
        if (perspectiveKey.func_151463_i() < 0) {
            PerspectiveMod.onPressed(Mouse.getEventButton() - 100, Mouse.getEventButtonState());
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui != null && perspectiveToggled && PerspectiveMod.config.holdMode) {
            PerspectiveMod.resetPerspective();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (perspectiveToggled) {
            PerspectiveMod.resetPerspective();
        }
    }

    public static void onPressed(int eventKey, boolean state) {
        if (eventKey == perspectiveKey.func_151463_i()) {
            if (PerspectiveMod.config.modEnabled) {
                if (state) {
                    perspectiveToggled = !perspectiveToggled;
                    cameraYaw = PerspectiveMod.mc.field_71439_g.field_70177_z;
                    cameraPitch = PerspectiveMod.mc.field_71439_g.field_70125_A;
                    if (perspectiveToggled) {
                        previousPerspective = PerspectiveMod.mc.field_71474_y.field_74320_O;
                        PerspectiveMod.mc.field_71474_y.field_74320_O = 1;
                    } else {
                        PerspectiveMod.mc.field_71474_y.field_74320_O = previousPerspective;
                    }
                } else if (PerspectiveMod.config.holdMode) {
                    PerspectiveMod.resetPerspective();
                }
            } else if (perspectiveToggled) {
                PerspectiveMod.resetPerspective();
            }
        }
    }

    public static boolean overrideMouse() {
        if (PerspectiveMod.mc.field_71415_G && Display.isActive()) {
            if (!perspectiveToggled) {
                return true;
            }
            PerspectiveMod.mc.field_71417_B.func_74374_c();
            float f1 = PerspectiveMod.mc.field_71474_y.field_74341_c * 0.6f + 0.2f;
            float f2 = f1 * f1 * f1 * 8.0f;
            float f3 = (float)PerspectiveMod.mc.field_71417_B.field_74377_a * f2;
            float f4 = (float)PerspectiveMod.mc.field_71417_B.field_74375_b * f2;
            if (PerspectiveMod.config.invertPitch) {
                f4 = -f4;
            }
            cameraYaw += f3 * 0.15f;
            if ((cameraPitch += f4 * 0.15f) > 90.0f) {
                cameraPitch = 90.0f;
            }
            if (cameraPitch < -90.0f) {
                cameraPitch = -90.0f;
            }
        }
        return false;
    }

    public static void resetPerspective() {
        perspectiveToggled = false;
        PerspectiveMod.mc.field_71474_y.field_74320_O = previousPerspective;
    }

    static {
        perspectiveToggled = false;
        cameraYaw = 0.0f;
        cameraPitch = 0.0f;
        previousPerspective = 0;
    }
}

