/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.sk1eroldanimations.tweaker;

import club.sk1er.mods.sk1eroldanimations.Sk1erOldAnimations;
import club.sk1er.mods.sk1eroldanimations.asm.EntityPlayerTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.EntityRendererTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.GuiIngameForgeTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.GuiPlayerTabOverlayTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.ItemRendererTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.LayerArmorBaseTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.LayerHeldItemTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.ModelBipedTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.RenderFishTransformer;
import club.sk1er.mods.sk1eroldanimations.asm.modcore.OnlineIndicatorTransformer;
import club.sk1er.mods.sk1eroldanimations.tweaker.transformer.ITransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    private final Multimap<String, ITransformer> transformerMap = ArrayListMultimap.create();
    public static boolean developmentEnvironment;
    public static final boolean outputBytecode;

    public ClassTransformer() {
        developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (developmentEnvironment) {
            this.registerTransformer(new RenderFishTransformer());
            this.registerTransformer(new ItemRendererTransformer());
            this.registerTransformer(new LayerArmorBaseTransformer());
            this.registerTransformer(new GuiIngameForgeTransformer());
            this.registerTransformer(new LayerHeldItemTransformer());
            this.registerTransformer(new ModelBipedTransformer());
            this.registerTransformer(new EntityRendererTransformer());
            this.registerTransformer(new GuiPlayerTabOverlayTransformer());
        }
        this.registerTransformer(new EntityPlayerTransformer());
        this.registerTransformer(new OnlineIndicatorTransformer());
    }

    private void registerTransformer(ITransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        return ClassTransformer.createTransformer(transformedName, bytes, this.transformerMap, outputBytecode);
    }

    public static byte[] createTransformer(String transformedName, byte[] bytes, Multimap<String, ITransformer> transformerMap, boolean outputBytecode) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        Sk1erOldAnimations.LOGGER.info("Found {} transformers for {}", new Object[]{transformers.size(), transformedName});
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (ITransformer transformer : transformers) {
            Sk1erOldAnimations.LOGGER.info("Applying transformer {} on {}...", new Object[]{transformer.getClass().getName(), transformedName});
            transformer.transform(classNode, transformedName);
        }
        ClassWriter classWriter = new ClassWriter(2);
        try {
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (Throwable e) {
            Sk1erOldAnimations.LOGGER.error("Exception when transforming " + transformedName + " : " + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        if (outputBytecode) {
            File bytecodeDirectory = new File("bytecode");
            String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
            File bytecodeOutput = new File(bytecodeDirectory, transformedClassName);
            try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                os.write(classWriter.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classWriter.toByteArray();
    }

    static {
        outputBytecode = Boolean.parseBoolean(System.getProperty("debugBytecode", "false"));
    }
}

