/*
 * Decompiled with CFR 0.152.
 */
package com.kbrewster.mojangapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kbrewster.API;
import com.kbrewster.exceptions.APIException;
import com.kbrewster.exceptions.InvalidPlayerException;
import com.kbrewster.mojangapi.MetricKeys;
import com.kbrewster.mojangapi.MojangStatistics;
import com.kbrewster.mojangapi.Name;
import com.kbrewster.mojangapi.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

@API.Reference(apiName="Mojang API", apiVersion="1.1.2")
public class MojangAPI
extends API {
    private static final String BASE_URL = "https://api.mojang.com";
    private static final String STATUS_URL = "https://status.mojang.com/check";

    public static Map<String, String> getStatus() throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String json = MojangAPI.sendGet(STATUS_URL);
        JsonArray status = new JsonParser().parse(json).getAsJsonArray();
        for (JsonElement element : status) {
            JsonObject obj = element.getAsJsonObject();
            obj.entrySet().forEach(s -> map.put((String)s.getKey(), ((JsonElement)s.getValue()).getAsString()));
        }
        return map;
    }

    public static String getName(String uuid) throws Exception {
        ArrayList<Name> names = MojangAPI.getNameHistoryByUUID(uuid);
        return names.get(names.size() - 1).getName();
    }

    public static ArrayList<Name> getNameHistory(String username) throws Exception {
        return MojangAPI.getNameHistory(MojangAPI.getUUID(username));
    }

    public static ArrayList<Name> getNameHistoryByUUID(String uuid) throws Exception {
        Gson gson = new Gson();
        ArrayList<Name> names = new ArrayList<Name>();
        String json = MojangAPI.sendGet(String.format("https://api.mojang.com/user/profiles/%s/names", uuid));
        JsonElement parser = new JsonParser().parse(json);
        if (parser.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        JsonArray arrayNames = parser.getAsJsonArray();
        arrayNames.forEach(obj -> {
            Name name = gson.fromJson((JsonElement)obj, Name.class);
            names.add(name);
        });
        return names;
    }

    public static String getUUID(String username) throws IOException, APIException, InvalidPlayerException {
        String json = MojangAPI.sendGet("https://api.mojang.com/users/profiles/minecraft/" + username);
        JsonElement parse = new JsonParser().parse(json);
        if (parse.isJsonNull()) {
            throw new InvalidPlayerException();
        }
        JsonObject obj = parse.getAsJsonObject();
        if (obj.get("error") instanceof JsonNull) {
            throw new APIException(obj.get("errorMessage").getAsString());
        }
        return obj.get("id").getAsString();
    }

    public static MojangStatistics getStatistics(MetricKeys key) throws IOException {
        String json = MojangAPI.sendPost("https://api.mojang.com/orders/statistics", "{\"metricKeys\": [\"" + key.getKey() + "\"]}");
        JsonElement obj = new JsonParser().parse(json);
        return new Gson().fromJson(obj, MojangStatistics.class);
    }

    private static Profile getProfile() throws IOException {
        return null;
    }
}

