/*
 * Decompiled with CFR 0.152.
 */
package net.xxxxxxx.bedwarsstats.rawtext;

import java.util.HashMap;
import java.util.Map;
import net.xxxxxxx.bedwarsstats.rawtext.TextAction;
import net.xxxxxxx.bedwarsstats.rawtext.TextColor;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RawText {
    private String text;
    private TextColor color;
    private JSONObject clickEvent;
    private JSONObject hoverEvent;

    public RawText setText(String text) {
        this.text = text;
        return this;
    }

    public RawText setColor(TextColor color) {
        this.color = color;
        return this;
    }

    public RawText setClickEvent(TextAction action, String value) {
        JSONObject json = new JSONObject();
        json.put("action", action.name().toLowerCase());
        json.put("value", value);
        this.clickEvent = json;
        return this;
    }

    public RawText setHoverEvent(TextAction action, String value) {
        JSONObject json = new JSONObject();
        json.put("action", action.name().toLowerCase());
        json.put("value", value);
        this.hoverEvent = json;
        return this;
    }

    public RawText setHoverEvent(TextAction action, HashMap<String, TextColor> value) {
        JSONObject json = new JSONObject();
        json.put("action", action.name().toLowerCase());
        JSONObject subJson = new JSONObject();
        subJson.put("text", "");
        JSONArray array = new JSONArray();
        for (Map.Entry<String, TextColor> e : value.entrySet()) {
            RawText rawText = new RawText();
            rawText.setText(e.getKey());
            rawText.setColor(e.getValue());
            array.add(rawText.build());
        }
        subJson.put("extra", array);
        json.put("value", subJson);
        this.hoverEvent = json;
        return this;
    }

    public JSONObject build() {
        JSONObject json = new JSONObject();
        if (this.text == null) {
            return null;
        }
        json.put("text", this.text);
        if (this.color != null) {
            json.put("color", this.color.name().toLowerCase());
        }
        if (this.clickEvent != null) {
            json.put("clickEvent", this.clickEvent);
        }
        if (this.hoverEvent != null) {
            json.put("hoverEvent", this.hoverEvent);
        }
        return json;
    }
}

