/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod;

public class Calculator {
    private static String[] functions = new String[]{"log", "ln", "arcsin", "arccos", "arctan", "sin", "cos", "tan", "floor", "ceiling", "round"};
    private static String[] operators = new String[]{"^", "*", "/", "+"};

    public static String preprocess(String input) {
        input = input.toLowerCase();
        input = Calculator.removeSpaces(input);
        input = Calculator.fixDecimalPoints(input);
        input = Calculator.fixFunctionBracketMultiply(input);
        input = Calculator.fillBrackets(input);
        return input;
    }

    public static String calc(String input) {
        System.out.println(input);
        if (Calculator.isNum(input)) {
            if (input.endsWith(".0")) {
                return input.substring(0, input.length() - 2);
            }
            return input;
        }
        if (input.indexOf("(") != -1) {
            int insidestart = input.indexOf("(");
            int insideend = Calculator.findEndBracketLocation(input, insidestart + 1);
            input = input.substring(0, insidestart) + Calculator.calc(input.substring(insidestart + 1, insideend)) + input.substring(insideend + 1);
            return Calculator.calc(input);
        }
        String earliestFunction = "";
        int earliestIndex = Integer.MAX_VALUE;
        for (String function : functions) {
            int i = input.indexOf(function);
            if (i == -1 || i >= earliestIndex) continue;
            earliestIndex = i;
            earliestFunction = function;
        }
        if (earliestIndex < Integer.MAX_VALUE) {
            int insideend;
            int insidestart = earliestIndex + earliestFunction.length();
            if (input.charAt(insidestart) != '(') {
                insideend = Calculator.findEndNextNum(input, insidestart);
                String temp = Calculator.calc(input.substring(insidestart, insideend));
                input = input.substring(0, earliestIndex) + Calculator.function(earliestFunction, temp) + input.substring(insideend);
            } else {
                insideend = Calculator.findEndBracketLocation(input, insidestart + 1);
                String temp = Calculator.calc(input.substring(insidestart, insideend));
                input = input.substring(0, earliestIndex) + Calculator.function(earliestFunction, Calculator.calc(input.substring(insidestart + 1, insideend))) + input.substring(insideend + 1);
            }
            return Calculator.calc(input);
        }
        int factIndex = input.indexOf("!");
        if (factIndex > -1) {
            int startIndex = Calculator.findStartPrevNum(input, factIndex);
            double d = Double.parseDouble(input.substring(startIndex, factIndex));
            input = input.substring(0, startIndex) + Calculator.factorial(d) + input.substring(factIndex + 1);
            return Calculator.calc(input);
        }
        for (String operator : operators) {
            int index = input.indexOf(operator);
            if (index <= -1) continue;
            int op1startIndex = Calculator.findStartPrevNum(input, index);
            int op2endIndex = Calculator.findEndNextNum(input, index + 1);
            String op1 = input.substring(op1startIndex, index);
            String op2 = input.substring(index + 1, op2endIndex);
            String temp = Calculator.process(op1, op2, operator);
            input = input.substring(0, op1startIndex) + temp + input.substring(op2endIndex);
            return Calculator.calc(input);
        }
        int index = input.indexOf("-");
        while (index > 0 && !"1234567890".contains(input.substring(index - 1, index)) || index == 0) {
            index = input.indexOf("-", index + 1);
        }
        if (index > -1) {
            int op1startIndex = Calculator.findStartPrevNum(input, index);
            int op2endIndex = Calculator.findEndNextNum(input, index + 1);
            System.out.println(op1startIndex + " " + index + " " + op2endIndex);
            String op1 = input.substring(op1startIndex, index);
            String op2 = input.substring(index + 1, op2endIndex);
            String temp = Calculator.process(op1, op2, "-");
            input = input.substring(0, op1startIndex) + temp + input.substring(op2endIndex);
            return Calculator.calc(input);
        }
        return "Unknown error, final value: " + input;
    }

    private static int findEndBracketLocation(String input, int startingIndex) {
        int lb = 0;
        for (int i = startingIndex; i < input.length(); ++i) {
            if (input.charAt(i) == '(') {
                ++lb;
            } else if (input.charAt(i) == ')') {
                --lb;
            }
            if (lb != -1) continue;
            return i;
        }
        return input.length();
    }

    private static int findEndNextNum(String input, int startingIndex) {
        boolean reachedNum = false;
        for (int i = startingIndex; i < input.length(); ++i) {
            if (i == startingIndex && input.charAt(i) == '-') continue;
            if (!reachedNum && "1234567890eE.".contains(input.substring(i, i + 1))) {
                reachedNum = true;
            }
            if (reachedNum && !"1234567890eE.".contains(input.substring(i, i + 1))) {
                return i;
            }
            if (!reachedNum || !"e".equalsIgnoreCase(input.substring(i, i + 1)) || i >= input.length() - 1 || !input.substring(i + 1, i + 2).equals("-")) continue;
            ++i;
        }
        return input.length();
    }

    private static int findStartPrevNum(String input, int startingIndex) {
        boolean reachedNum = false;
        for (int i = startingIndex; i > 0; --i) {
            if (!reachedNum && "1234567890eE.".contains(input.substring(i - 1, i))) {
                reachedNum = true;
            }
            if (!reachedNum || "1234567890eE.".contains(input.substring(i - 1, i))) continue;
            if ("-".equals(input.substring(i - 1, i)) && (i > 1 && input.substring(i - 2, i - 1).equalsIgnoreCase("e") || i == 1)) {
                --i;
                continue;
            }
            if (i > 0 && input.substring(i - 2, i - 1).equals("-")) {
                return i - 1;
            }
            return i;
        }
        return 0;
    }

    private static boolean isNum(String input) {
        return input.matches("-?(((\\d+\\.\\d+)|(\\d+)|(((\\d+\\.\\d+)|(\\d+))[Ee]-?((\\d+\\.\\d+)|(\\d+)))))");
    }

    private static String function(String func, String operand) {
        if ("log".equals(func)) {
            return String.valueOf(Math.log10(Double.parseDouble(operand)));
        }
        if ("ln".equals(func)) {
            return String.valueOf(Math.log(Double.parseDouble(operand)));
        }
        if ("arcsin".equals(func)) {
            return String.valueOf(Math.asin(Double.parseDouble(operand)));
        }
        if ("arccos".equals(func)) {
            return String.valueOf(Math.acos(Double.parseDouble(operand)));
        }
        if ("arctan".equals(func)) {
            return String.valueOf(Math.atan(Double.parseDouble(operand)));
        }
        if ("sin".equals(func)) {
            return String.valueOf(Math.sin(Double.parseDouble(operand)));
        }
        if ("cos".equals(func)) {
            return String.valueOf(Math.cos(Double.parseDouble(operand)));
        }
        if ("tan".equals(func)) {
            return String.valueOf(Math.tan(Double.parseDouble(operand)));
        }
        if ("floor".equals(func)) {
            return String.valueOf(Math.floor(Double.parseDouble(operand)));
        }
        if ("ceil".equals(func)) {
            return String.valueOf(Math.ceil(Double.parseDouble(operand)));
        }
        if ("round".equals(func)) {
            return String.valueOf(Math.round(Double.parseDouble(operand)));
        }
        return "0";
    }

    private static double factorial(double n) {
        double[] p = new double[]{676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
        double pi = Math.PI;
        double e = Math.E;
        if (n < 0.5) {
            return pi / (Math.sin(pi * n) * Calculator.factorial(1.0 - n));
        }
        n -= 1.0;
        double x = 0.9999999999998099;
        for (int i = 0; i < p.length; ++i) {
            x += p[i] / (n + (double)i + 1.0);
        }
        double t = n + (double)p.length - 0.5;
        return Math.sqrt(2.0 * pi) * Math.pow(t, n + 0.5) * Math.pow(e, -t) * x;
    }

    private static String process(String a, String b, String operation) {
        System.out.println(a + " " + operation + " " + b);
        if ("^".equals(operation)) {
            return String.valueOf(Math.pow(Double.parseDouble(a), Double.parseDouble(b)));
        }
        if ("*".equals(operation)) {
            return String.valueOf(Double.parseDouble(a) * Double.parseDouble(b));
        }
        if ("/".equals(operation)) {
            return String.valueOf(Double.parseDouble(a) / Double.parseDouble(b));
        }
        if ("+".equals(operation)) {
            return String.valueOf(Double.parseDouble(a) + Double.parseDouble(b));
        }
        if ("-".equals(operation)) {
            return String.valueOf(Double.parseDouble(a) - Double.parseDouble(b));
        }
        return "0";
    }

    private static String fillBrackets(String input) {
        int lb = 0;
        int rb = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '(') {
                ++lb;
                continue;
            }
            if (input.charAt(i) != ')') continue;
            ++rb;
        }
        while (lb > rb) {
            input = input + ")";
            --lb;
        }
        while (rb > lb) {
            input = "(" + input;
            --rb;
        }
        return input;
    }

    private static String removeSpaces(String input) {
        input = input.replaceAll(" ", "");
        return input;
    }

    private static String fixDecimalPoints(String input) {
        for (int i = 0; i < input.length() && input.indexOf(".", i) > -1; ++i) {
            if ((i = input.indexOf(".", i)) == input.length() - 1) {
                input = input + "0";
                continue;
            }
            if (i == 0) {
                input = "0" + input;
                ++i;
                continue;
            }
            if (!"1234567890".contains(input.substring(i + 1, i + 2))) {
                input = input.substring(0, i + 1) + "0" + input.substring(i + 1);
            }
            if ("1234567890".contains(input.substring(i - 1, i))) continue;
            input = input.substring(0, i) + "0" + input.substring(i);
            ++i;
        }
        return input;
    }

    private static String fixFunctionBracketMultiply(String input) {
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '!') {
                if (i >= input.length() - 1 || "!^+-*/)".contains(input.substring(i + 1, i + 2))) continue;
                input = input.substring(0, i + 1) + "*" + input.substring(i + 1);
                continue;
            }
            if (input.charAt(i) == '(') {
                if (i <= 0 || !"!)1234567890eE".contains(input.substring(i - 1, i))) continue;
                input = input.substring(0, i) + "*" + input.substring(i);
                continue;
            }
            if (input.charAt(i) == ')') {
                if (i >= input.length() - 1 || "!^+-*/)".contains(input.substring(i + 1, i + 2))) continue;
                input = input.substring(0, i + 1) + "*" + input.substring(i + 1);
                continue;
            }
            if (!"1234567890".contains(input.substring(i, i + 1)) || i >= input.length() - 1 || "1234567890.!^+-*/)eE".contains(input.substring(i + 1, i + 2))) continue;
            input = input.substring(0, i + 1) + "*" + input.substring(i + 1);
        }
        return input;
    }
}

