/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.formatters.bridge;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.util.ArrayList;
import java.util.HashMap;

public class CompactBridgeStatsFormatter {
    public static ArrayList<String> formatStats(HashMap<String, String> stats, String mode) {
        ArrayList<String> output = new ArrayList<String>();
        String df = BridgeDuelsStatsMod.settings.getstatprefixcolour();
        if (stats.get("Error") != null) {
            output.add(stats.get("Error"));
        } else {
            String wins = CompactBridgeStatsFormatter.formatWins(stats.get("bridge" + mode + "wins"));
            String winloss = CompactBridgeStatsFormatter.formatWinLoss(stats.get("bridge" + mode + "winloss"));
            String winstreak = CompactBridgeStatsFormatter.formatWinstreak(stats.get("bridge" + mode + "winstreak"), mode);
            output.add(CompactBridgeStatsFormatter.unformatName(stats.get("formattedname")) + df + " - Wins: " + wins + df + " W/L: " + winloss + df + " WS: " + winstreak);
        }
        return output;
    }

    private static String unformatName(String name) {
        if (!name.contains("[")) {
            return name;
        }
        return name.substring(0, name.indexOf("[")) + name.substring(name.indexOf("]") + 2);
    }

    private static String formatWinstreak(String winstreak, String mode) {
        if (winstreak.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long ws = Long.parseLong(winstreak);
        if (mode.length() > 1) {
            ws *= 10L;
        }
        String line = "";
        if (ws == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (ws < 10L) {
            line = line + ChatFormatting.GRAY;
        } else if (ws < 25L) {
            line = line + ChatFormatting.WHITE;
        } else if (ws < 50L) {
            line = line + ChatFormatting.GOLD;
        } else if (ws < 100L) {
            line = line + ChatFormatting.AQUA;
        } else if (ws < 250L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (ws >= 250L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winstreak;
        return line;
    }

    private static String formatWinLoss(String winloss) {
        if (winloss.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long wl = Long.parseLong(winloss);
        String line = "";
        if (wl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (wl < 100L) {
            line = line + ChatFormatting.GRAY;
        } else if (wl < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (wl < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (wl < 1000L) {
            line = line + ChatFormatting.AQUA;
        } else if (wl < 2000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (wl >= 2000L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winloss;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatWins(String wins) {
        long w = Long.parseLong(wins);
        String line = "";
        if (w == 0L) {
            line = line + ChatFormatting.BLACK;
        } else if (w < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (w < 100L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (w < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (w < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (w < 1000L) {
            line = line + ChatFormatting.AQUA;
        } else if (w < 2000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (w < 5000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (w < 10000L) {
            line = line + ChatFormatting.YELLOW;
        } else if (w >= 10000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        }
        line = line + wins;
        return line;
    }

    public static String formatNetworkLevel(String networklvl) {
        long lvl = Long.parseLong(networklvl);
        String line = "";
        if (lvl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (lvl < 1000L) {
            line = line + ChatFormatting.GRAY;
        } else if (lvl < 2500L) {
            line = line + ChatFormatting.WHITE;
        } else if (lvl < 5000L) {
            line = line + ChatFormatting.GOLD;
        } else if (lvl < 10000L) {
            line = line + ChatFormatting.AQUA;
        } else if (lvl < 15000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (lvl < 20000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (lvl < 25000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (lvl >= 25000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + networklvl;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }
}

