/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.formatters.duels;

import com.mojang.realmsclient.gui.ChatFormatting;
import daniel.bridgeduelsstatsmod.BridgeDuelsStatsMod;
import java.util.ArrayList;
import java.util.HashMap;

public class SimpleDuelsStatsFormatter {
    public static ArrayList<String> formatStats(HashMap<String, String> stats, String mode) {
        ArrayList<String> output = new ArrayList<String>();
        String df = BridgeDuelsStatsMod.settings.getstatprefixcolour();
        if (stats.get("Error") != null) {
            output.add(stats.get("Error"));
        } else {
            String wins = SimpleDuelsStatsFormatter.formatWins(stats.get(mode + "wins"));
            String winloss = SimpleDuelsStatsFormatter.formatWinLoss(stats.get(mode + "winloss"));
            String kills = SimpleDuelsStatsFormatter.formatKills(stats.get(mode + "kills"));
            String killdeath = SimpleDuelsStatsFormatter.formatKillDeath(stats.get(mode + "killdeath"));
            String winstreak = SimpleDuelsStatsFormatter.formatWinstreak(stats.get(mode + "winstreak"), mode);
            output.add(stats.get("formattedname") + df + " Lvl: " + SimpleDuelsStatsFormatter.formatNetworkLevel(stats.get("networklvl")) + df + ", Wins: " + wins);
            output.add(df + "W/L: " + winloss + df + ", Kills & K/D: " + kills + df + " & " + killdeath + df + ", WS: " + winstreak);
        }
        return output;
    }

    private static String formatKills(String goals) {
        if (goals.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long g = Long.parseLong(goals);
        String line = "";
        if (g == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (g < 250L) {
            line = line + ChatFormatting.GRAY;
        } else if (g < 5000L) {
            line = line + ChatFormatting.WHITE;
        } else if (g < 1000L) {
            line = line + ChatFormatting.GOLD;
        } else if (g < 2500L) {
            line = line + ChatFormatting.AQUA;
        } else if (g < 5000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (g >= 5000L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + goals;
        return line;
    }

    private static String formatWinstreak(String winstreak, String mode) {
        if (winstreak.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long ws = Long.parseLong(winstreak);
        if (mode.equals("sumo")) {
            ws /= 4L;
        }
        String line = "";
        if (ws == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (ws < 10L) {
            line = line + ChatFormatting.GRAY;
        } else if (ws < 25L) {
            line = line + ChatFormatting.WHITE;
        } else if (ws < 50L) {
            line = line + ChatFormatting.GOLD;
        } else if (ws < 100L) {
            line = line + ChatFormatting.AQUA;
        } else if (ws < 250L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (ws >= 250L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winstreak;
        return line;
    }

    private static String formatWinLoss(String winloss) {
        if (winloss.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long wl = Long.parseLong(winloss);
        String line = "";
        if (wl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (wl < 100L) {
            line = line + ChatFormatting.GRAY;
        } else if (wl < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (wl < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (wl < 1000L) {
            line = line + ChatFormatting.AQUA;
        } else if (wl < 2000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (wl >= 2000L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + winloss;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatKillDeath(String killdeath) {
        if (killdeath.equals("NaN")) {
            return ChatFormatting.DARK_GRAY + "NaN";
        }
        long kd = Long.parseLong(killdeath);
        String line = "";
        if (kd == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (kd < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (kd < 100L) {
            line = line + ChatFormatting.WHITE;
        } else if (kd < 150L) {
            line = line + ChatFormatting.GOLD;
        } else if (kd < 250L) {
            line = line + ChatFormatting.AQUA;
        } else if (kd < 500L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (kd >= 500L) {
            line = line + ChatFormatting.DARK_RED;
        }
        line = line + killdeath;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }

    private static String formatWins(String wins) {
        long w = Long.parseLong(wins);
        String line = "";
        if (w == 0L) {
            line = line + ChatFormatting.BLACK;
        } else if (w < 50L) {
            line = line + ChatFormatting.GRAY;
        } else if (w < 100L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (w < 250L) {
            line = line + ChatFormatting.WHITE;
        } else if (w < 500L) {
            line = line + ChatFormatting.GOLD;
        } else if (w < 1000L) {
            line = line + ChatFormatting.AQUA;
        } else if (w < 2000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (w < 5000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (w < 10000L) {
            line = line + ChatFormatting.YELLOW;
        } else if (w >= 10000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        }
        line = line + wins;
        return line;
    }

    public static String formatNetworkLevel(String networklvl) {
        long lvl = Long.parseLong(networklvl);
        String line = "";
        if (lvl == 0L) {
            line = line + ChatFormatting.DARK_GRAY;
        } else if (lvl < 1000L) {
            line = line + ChatFormatting.GRAY;
        } else if (lvl < 2500L) {
            line = line + ChatFormatting.WHITE;
        } else if (lvl < 5000L) {
            line = line + ChatFormatting.GOLD;
        } else if (lvl < 10000L) {
            line = line + ChatFormatting.AQUA;
        } else if (lvl < 15000L) {
            line = line + ChatFormatting.DARK_GREEN;
        } else if (lvl < 20000L) {
            line = line + ChatFormatting.DARK_RED;
        } else if (lvl < 25000L) {
            line = line + ChatFormatting.DARK_PURPLE;
        } else if (lvl >= 25000L) {
            line = line + ChatFormatting.BLACK;
        }
        line = line + networklvl;
        line = line.substring(0, line.length() - 2) + "." + line.substring(line.length() - 2);
        return line;
    }
}

