/*
 * Decompiled with CFR 0.152.
 */
package daniel.bridgeduelsstatsmod.stats;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import daniel.bridgeduelsstatsmod.stats.UUIDCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class StatsGetter {
    public static JsonElement getPlayer(String name, String key) throws IOException {
        String uuid = UUIDCache.getUUID(name.toLowerCase());
        if (uuid != null) {
            if (uuid.equals("")) {
                return StatsGetter.returnNullPlayer();
            }
            return StatsGetter.getPlayerFromUUID(uuid, key);
        }
        String sURL = "https://api.hypixel.net/player?name=" + name + "&key=" + key;
        URL url = new URL(sURL);
        URLConnection request = url.openConnection();
        request.connect();
        JsonParser jp = new JsonParser();
        JsonElement root = jp.parse((Reader)new InputStreamReader((InputStream)request.getContent()));
        JsonObject rootobj = root.getAsJsonObject();
        return rootobj;
    }

    public static JsonElement returnNullPlayer() {
        return new JsonParser().parse("{\"success\":true,\"player\":null}");
    }

    public static JsonElement getPlayerFromUUID(String uuid, String key) throws IOException {
        String sURL = "https://api.hypixel.net/player?uuid=" + uuid + "&key=" + key;
        URL url = new URL(sURL);
        URLConnection request = url.openConnection();
        request.connect();
        JsonParser jp = new JsonParser();
        JsonElement root = jp.parse((Reader)new InputStreamReader((InputStream)request.getContent()));
        return root;
    }
}

