/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.autogg;

import club.sk1er.autogg.command.AutoGGCommand;
import club.sk1er.autogg.config.AutoGGConfig;
import club.sk1er.autogg.listener.AutoGGListener;
import club.sk1er.modcore.ModCoreInstaller;
import club.sk1er.mods.core.universal.ChatColor;
import club.sk1er.mods.core.util.MinecraftUtils;
import club.sk1er.mods.core.util.Multithreading;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="autogg", name="AutoGG", version="4.0.3", acceptedMinecraftVersions="[1.8.9]")
public class AutoGG {
    public static final String VERSION = "4.0.3";
    private static final String[] ACCEPTED_CONFIG_VERSIONS = new String[]{"2"};
    public static boolean validConfigVersion;
    public static boolean triggerFetchSuccess;
    private final Logger logger = LogManager.getLogger((String)"AutoGG");
    private final String prefix = ChatColor.BLUE + "[AutoGG] " + ChatColor.RESET;
    private static JsonObject triggerJson;
    public static Map<String, String> triggerMeta;
    public static final Map<String, List<Pattern>> ggRegexes;
    public static final Map<String, Pattern> otherRegexes;
    public static final Map<String, String> other;
    private AutoGGConfig autoGGConfig;
    private boolean running;
    @Mod.Instance(value="autogg")
    public static AutoGG instance;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCoreInstaller.initializeModCore(Minecraft.func_71410_x().field_71412_D);
        this.autoGGConfig = new AutoGGConfig();
        this.autoGGConfig.preload();
        ClientCommandHandler.instance.func_71560_a((ICommand)new AutoGGCommand());
        MinecraftForge.EVENT_BUS.register((Object)new AutoGGListener());
        AutoGG.downloadTriggers(false);
    }

    public static void downloadTriggers(boolean sendChatMsg) {
        Multithreading.runAsync(() -> {
            try {
                triggerFetchSuccess = true;
                validConfigVersion = true;
                triggerJson = new JsonParser().parse(AutoGG.fetchString("http://static.sk1er.club/autogg/regex_triggers_new.json")).getAsJsonObject();
                assert (Arrays.asList(ACCEPTED_CONFIG_VERSIONS).contains(triggerJson.get("triggers_format").toString()));
                triggerMeta = (Map)new Gson().fromJson(triggerJson.get("meta"), new TypeToken<HashMap<String, String>>(){}.getType());
            }
            catch (IOException e) {
                if (sendChatMsg) {
                    MinecraftUtils.sendMessage((String)AutoGG.instance.prefix, (String)(ChatColor.RED + "Unable to fetch triggers! Do you have an internet connection?"));
                }
                AutoGG.instance.logger.error("Failed to fetch triggers.", (Throwable)e);
                triggerFetchSuccess = false;
                return;
            }
            catch (JsonSyntaxException e) {
                if (sendChatMsg) {
                    MinecraftUtils.sendMessage((String)AutoGG.instance.prefix, (String)(ChatColor.RED + ChatColor.BOLD.toString() + "JSON Syntax Error! Contact the mod authors if you see this message!"));
                }
                AutoGG.instance.logger.error("JSON Syntax Error! Contact us in the support channel at https://discord.gg/sk1er.", (Throwable)e);
                triggerFetchSuccess = false;
                return;
            }
            catch (AssertionError | NullPointerException e) {
                if (sendChatMsg) {
                    MinecraftUtils.sendMessage((String)AutoGG.instance.prefix, (String)(ChatColor.RED + "Unsupported triggers version! Please update AutoGG!"));
                }
                AutoGG.instance.logger.error("Unsupported triggers version! Please update AutoGG!");
                validConfigVersion = false;
                return;
            }
            if (sendChatMsg) {
                MinecraftUtils.sendMessage((String)AutoGG.instance.prefix, (String)(ChatColor.GREEN + "Successfully fetched triggers!"));
            }
        });
    }

    public void getDataFromDownloadedTriggers() {
        Set<String> keySet;
        JsonObject firstServerObject;
        ggRegexes.clear();
        otherRegexes.clear();
        other.clear();
        try {
            firstServerObject = triggerJson.get("servers").getAsJsonObject().get(AutoGG.keySet(triggerJson.get("servers").getAsJsonObject()).iterator().next()).getAsJsonObject();
        }
        catch (NullPointerException e) {
            AutoGG.setDefaultTriggerData();
            return;
        }
        Set<String> ggOptions = AutoGG.keySet(firstServerObject.get("gg_triggers").getAsJsonObject());
        Set<String> otherPatternOptions = AutoGG.keySet(firstServerObject.get("other_patterns").getAsJsonObject());
        Set<String> otherOptions = AutoGG.keySet(firstServerObject.get("other").getAsJsonObject());
        for (String s : ggOptions) {
            ggRegexes.put(s, new ArrayList());
        }
        String ip = AutoGG.getServerIP();
        if ("".equals(ip)) {
            AutoGG.setDefaultTriggerData();
            return;
        }
        try {
            keySet = AutoGG.keySet(triggerJson.get("servers").getAsJsonObject());
        }
        catch (NullPointerException e) {
            instance.getLogger().error("Trigger download silently failed.");
            return;
        }
        for (String a : keySet) {
            String p;
            if (!Pattern.compile(a).matcher(ip).matches()) continue;
            JsonObject data = triggerJson.get("servers").getAsJsonObject().get(a).getAsJsonObject();
            for (String s : ggOptions) {
                for (JsonElement j : data.get("gg_triggers").getAsJsonObject().get(s).getAsJsonArray()) {
                    ggRegexes.get(s).add(Pattern.compile(j.toString().substring(1, j.toString().length() - 1).replaceAll("\\\\{2}", "\\\\")));
                }
            }
            for (String s : otherPatternOptions) {
                p = data.get("other_patterns").getAsJsonObject().get(s).toString();
                otherRegexes.put(s, Pattern.compile(p.substring(1, p.length() - 1).replaceAll("\\\\{2}", "\\\\").replaceAll("(?<!\\\\)\\$\\{antigg_strings}", String.join((CharSequence)"|", AutoGG.getAntiGGStrings()))));
            }
            for (String s : otherOptions) {
                p = data.get("other").getAsJsonObject().get(s).toString();
                other.put(s, p.substring(1, p.length() - 1));
            }
            return;
        }
        AutoGG.setDefaultTriggerData();
    }

    private static void setDefaultTriggerData() {
        Pattern nonMatching = Pattern.compile("$^");
        otherRegexes.put("antigg", nonMatching);
        otherRegexes.put("anti_karma", nonMatching);
        other.put("msg", "");
    }

    private static String[] getAntiGGStrings() {
        String[] primaryStrings = AutoGGListener.getPrimaryStrings();
        String[] secondaryStrings = AutoGGListener.getSecondaryStrings();
        String[] joinedArray = (String[])Array.newInstance(primaryStrings.getClass().getComponentType(), primaryStrings.length + secondaryStrings.length);
        System.arraycopy(primaryStrings, 0, joinedArray, 0, primaryStrings.length);
        System.arraycopy(secondaryStrings, 0, joinedArray, primaryStrings.length, secondaryStrings.length);
        return joinedArray;
    }

    public static Set<String> keySet(JsonObject json) throws NullPointerException {
        try {
            return json.keySet();
        }
        catch (NoSuchMethodError e) {
            HashSet<String> keySet = new HashSet<String>();
            for (Map.Entry entry : json.entrySet()) {
                keySet.add((String)entry.getKey());
            }
            return keySet;
        }
    }

    public static String getServerIP() {
        try {
            return Minecraft.func_71410_x().func_147104_D().field_78845_b.replaceAll("^(.*):\\d{1,5}$", "$1").toLowerCase(Locale.ENGLISH);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public boolean works() {
        return validConfigVersion && triggerFetchSuccess;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public AutoGGConfig getAutoGGConfig() {
        return this.autoGGConfig;
    }

    public static String fetchString(String url) throws IOException {
        String s;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.addRequestProperty("User-Agent", "Mozilla/4.76 (Sk1er AutoGG)");
            connection.setReadTimeout(15000);
            connection.setConnectTimeout(15000);
            connection.setDoOutput(true);
            try (InputStream setup = connection.getInputStream();){
                s = IOUtils.toString((InputStream)setup, (Charset)Charset.defaultCharset());
            }
        }
        catch (Exception e) {
            AutoGG.instance.logger.error("Failed to fetch string.", (Throwable)e);
            throw new IOException("Failed to fetch triggers!");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return s;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getPrefix() {
        return this.prefix;
    }

    static {
        triggerFetchSuccess = true;
        ggRegexes = new HashMap<String, List<Pattern>>();
        otherRegexes = new HashMap<String, Pattern>();
        other = new HashMap<String, String>();
    }
}

