/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.autogg.command;

import club.sk1er.autogg.AutoGG;
import club.sk1er.autogg.listener.AutoGGListener;
import club.sk1er.mods.core.ModCore;
import club.sk1er.mods.core.universal.ChatColor;
import club.sk1er.mods.core.util.MinecraftUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class AutoGGCommand
extends CommandBase {
    private final String prefix = AutoGG.instance.getPrefix();
    private static final SimpleDateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat LOCALE_FORMAT = DateFormat.getDateInstance(3, Locale.getDefault());

    private static Date parseDate(String date) {
        try {
            return ISO_8601.parse(date);
        }
        catch (ParseException e) {
            return new Date(0L);
        }
    }

    public String func_71517_b() {
        return "autogg";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [refresh|triggers|info|credits|help]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0) {
            ModCore.getInstance().getGuiHandler().open((GuiScreen)AutoGG.instance.getAutoGGConfig().gui());
        } else {
            switch (args[0]) {
                case "refresh": {
                    MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.YELLOW + "Fetching triggers..."));
                    AutoGG.downloadTriggers(true);
                    AutoGGListener.switchTriggerset();
                    break;
                }
                case "triggers": {
                    for (String key : AutoGG.ggRegexes.keySet()) {
                        if (AutoGG.ggRegexes.get(key).isEmpty()) continue;
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.AQUA + key.replaceAll("_", " ").toUpperCase(Locale.ENGLISH) + ":"));
                        for (Pattern pattern : AutoGG.ggRegexes.get(key)) {
                            MinecraftUtils.sendMessage((String)"  ", (String)pattern.toString());
                        }
                    }
                    for (String key : AutoGG.otherRegexes.keySet()) {
                        if ("$^".equals(AutoGG.otherRegexes.get(key).toString())) continue;
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.AQUA + key.replaceAll("_", " ").toUpperCase(Locale.ENGLISH) + ": " + ChatColor.RESET + AutoGG.otherRegexes.get(key)));
                    }
                    break;
                }
                case "info": {
                    MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "Mod Version: " + "4.0.3"));
                    try {
                        int triggersSize = AutoGG.ggRegexes.get("triggers").size();
                        int casualTriggersSize = AutoGG.ggRegexes.get("casual_triggers").size();
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "Triggers Version: " + AutoGG.triggerMeta.get("version").replaceAll("\"", "")));
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "Triggers last updated on " + LOCALE_FORMAT.format(AutoGGCommand.parseDate(AutoGG.triggerMeta.get("upload_date").replaceAll("\"", "")))));
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "Triggers info message: " + AutoGG.triggerMeta.get("note").replaceAll("\"", "")));
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + Integer.toString(triggersSize) + " Trigger" + (triggersSize == 1 ? "" : "s") + ", " + casualTriggersSize + " Casual Trigger" + (casualTriggersSize == 1 ? "" : "s")));
                    }
                    catch (NullPointerException e) {
                        MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.RED + "Could not get Trigger Meta! Were the triggers downloaded properly?"));
                        AutoGG.instance.getLogger().error("Could not get trigger meta.", (Throwable)e);
                    }
                    break;
                }
                case "credits": {
                    MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "AutoGG Originally created by 2Pi, continued by Sk1er LLC. Regex update & multi-server support by SirNapkin1334."));
                    MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "Additional special thanks to: LlamaLad7, FalseHonesty, DJTheRedstoner, Pluggs and Unextracted!"));
                    break;
                }
                default: {
                    ChatComponentText discordLink = new ChatComponentText(this.prefix + ChatColor.GREEN + "For support with AutoGG, go to discord.gg/sk1er.");
                    discordLink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/sk1er"));
                    discordLink.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Click to join our Discord.")));
                    ChatComponentText autoGGConfig = new ChatComponentText(this.prefix + ChatColor.GREEN + "To configure AutoGG, run /autogg.");
                    autoGGConfig.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/autogg"));
                    autoGGConfig.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("Click to run /autogg.")));
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)discordLink);
                    Minecraft.func_71410_x().field_71439_g.func_146105_b((IChatComponent)autoGGConfig);
                    MinecraftUtils.sendMessage((String)this.prefix, (String)(ChatColor.GREEN + "AutoGG Commands: refresh, info, credits, help"));
                    break;
                }
            }
        }
    }

    public List<String> func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? AutoGGCommand.func_71530_a((String[])args, (String[])new String[]{"refresh", "info", "credits", "help"}) : null;
    }

    public int func_82362_a() {
        return -1;
    }
}

