/*
 * Decompiled with CFR 0.152.
 */
package me.powns.potionhud.gui;

import java.util.Iterator;
import me.powns.potionhud.PotionHudMod;
import me.powns.potionhud.gui.menu.MainMenu;
import me.powns.potionhud.gui.menu.effectsettings.EffectFlickerMenu;
import me.powns.potionhud.settings.EffectSetting;
import me.powns.potionhud.settings.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class HudRenderer {
    private PotionHudMod mod;
    private Settings settings;
    private Minecraft mc;
    private double zLevel;

    public HudRenderer(PotionHudMod mod) {
        this.mod = mod;
        this.settings = mod.getSettings();
        this.mc = Minecraft.func_71410_x();
        this.zLevel = 1.0;
    }

    @SubscribeEvent
    public void onHudRender(TickEvent.RenderTickEvent e) {
        if (this.mc.field_71441_e != null) {
            if (this.mc.field_71462_r instanceof MainMenu) {
                this.renderMenuHUD();
                return;
            }
            if (this.mc.field_71462_r == null || this.settings.isShowWhileChat() && this.mc.field_71462_r instanceof GuiChat) {
                this.renderIngameHUD();
            }
        }
    }

    public void renderSingleCustomCoords(EffectSetting setting, int x, int y) {
        int minX = x;
        int minY = y;
        int maxX = x + 110;
        int maxY = y + 30;
        this.renderDummyEffect(setting, minX, minY, maxX, maxY);
    }

    public void renderSingleCustomCoordsWithOtherSettings(EffectSetting setting, EffectSetting syncFrom, int x, int y) {
        int minX = x;
        int minY = y;
        int maxX = x + 110;
        int maxY = y + 30;
        this.renderDummyEffectWithOtherColors(setting, syncFrom, minX, minY, maxX, maxY);
    }

    private void renderMenuHUD() {
        int[] effects = new int[]{1, 12, 2, 14};
        int addToY = -22;
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddX())), (float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddY())), (float)0.0f);
        GL11.glScalef((float)this.settings.getScale(), (float)this.settings.getScale(), (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
        Gui.func_73734_a((int)(this.settings.getAddX() + 6), (int)(this.settings.getAddY() + 3), (int)(this.settings.getMaxX() + 16), (int)this.settings.getMaxY(), (int)this.getColorWithAlpha(8168374, 50));
        Gui.func_73734_a((int)(this.settings.getAddX() + 5), (int)(this.settings.getAddY() + 2), (int)(this.settings.getAddX() + 6), (int)(this.settings.getAddY() + 12), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getAddX() + 5), (int)(this.settings.getAddY() + 2), (int)(this.settings.getAddX() + 15), (int)(this.settings.getAddY() + 3), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getMaxX() + 17), (int)(this.settings.getAddY() + 2), (int)(this.settings.getMaxX() + 7), (int)(this.settings.getAddY() + 3), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getMaxX() + 17), (int)(this.settings.getAddY() + 2), (int)(this.settings.getMaxX() + 16), (int)(this.settings.getAddY() + 12), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getAddX() + 5), (int)this.settings.getMaxY(), (int)(this.settings.getAddX() + 15), (int)(this.settings.getMaxY() + 1), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getAddX() + 5), (int)(this.settings.getMaxY() + 1), (int)(this.settings.getAddX() + 6), (int)(this.settings.getMaxY() - 10), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getMaxX() + 17), (int)this.settings.getMaxY(), (int)(this.settings.getMaxX() + 7), (int)(this.settings.getMaxY() + 1), (int)this.getColorWithAlpha(8103095, 255));
        Gui.func_73734_a((int)(this.settings.getMaxX() + 17), (int)(this.settings.getMaxY() + 1), (int)(this.settings.getMaxX() + 16), (int)(this.settings.getMaxY() - 10), (int)this.getColorWithAlpha(8103095, 255));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
        GL11.glScalef((float)(1.0f / this.settings.getScale()), (float)(1.0f / this.settings.getScale()), (float)1.0f);
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddX()), (float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddY()), (float)0.0f);
        for (int effect : effects) {
            EffectSetting setting = this.settings.getEffectSetting(effect);
            int minX = this.settings.getAddX();
            int minY = this.settings.getAddY();
            int maxX = this.settings.getAddX() + 110;
            int maxY = this.settings.getAddY() + 30 + (addToY += 22);
            this.renderDummyEffect(setting, minX, minY + addToY, maxX, maxY);
            this.settings.setMinX(minX);
            this.settings.setMinY(minY);
            this.settings.setMaxX(maxX);
            this.settings.setMaxY(maxY);
        }
    }

    private void renderIngameHUD() {
        Iterator it = this.mc.field_71439_g.func_70651_bq().iterator();
        int addToY = -22;
        while (it.hasNext()) {
            addToY += 22;
            PotionEffect pot = (PotionEffect)it.next();
            EffectSetting setting = this.settings.getEffectSetting(pot.func_76456_a());
            if (this.settings.getEffectSetting(pot.func_76456_a()) == null) continue;
            if (setting.isEnabled() && this.mc.field_71439_g.func_82165_m(setting.getEffectId())) {
                int minX = this.settings.getAddX();
                int minY = this.settings.getAddY() + addToY;
                int maxX = this.settings.getAddX() + 110;
                int maxY = this.settings.getAddY() + 30 + addToY;
                if (setting.isFlickerWhenLow() && pot.func_76459_b() / 20 <= setting.getFlickerStartTime()) {
                    int flickerSpeed = setting.getFlickerSpeed() * 55000;
                    if (System.currentTimeMillis() * 1000L / (long)flickerSpeed % 2L == 0L) {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
                        this.renderEffect(setting, minX, minY, maxX, maxY);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
                    }
                } else {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
                    this.renderEffect(setting, minX, minY, maxX, maxY);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)this.settings.getOpacity() / 255.0f));
                }
                this.settings.setMinX(minX);
                this.settings.setMinY(minY);
                this.settings.setMaxX(maxX);
                this.settings.setMaxY(maxY);
                continue;
            }
            addToY -= 20;
        }
    }

    private void renderDummyEffect(EffectSetting setting, int minX, int minY, int maxX, int maxY) {
        if (this.mc.field_71462_r instanceof EffectFlickerMenu && setting.isFlickerWhenLow()) {
            int flickerSpeed = setting.getFlickerSpeed() * 55000;
            if (System.currentTimeMillis() * 1000L / (long)flickerSpeed % 2L == 0L) {
                if (this.settings.isRenderIcons()) {
                    this.renderDummyIcon(setting, minX, minY, maxX, maxY);
                }
                this.renderDummyText(setting, minX, minY, maxX, maxY, 100);
            }
        } else {
            if (this.settings.isRenderIcons()) {
                this.renderDummyIcon(setting, minX, minY, maxX, maxY);
            }
            this.renderDummyText(setting, minX, minY, maxX, maxY, 660);
        }
    }

    private void renderDummyEffectWithOtherColors(EffectSetting setting, EffectSetting syncFrom, int minX, int minY, int maxX, int maxY) {
        if (this.settings.isRenderIcons()) {
            this.renderDummyIcon(setting, minX, minY, maxX, maxY);
        }
        this.renderDummyTextWithOtherColors(setting, syncFrom, minX, minY, maxX, maxY, 660);
    }

    private void renderEffect(EffectSetting setting, int minX, int minY, int maxX, int maxY) {
        if (this.settings.isRenderIcons()) {
            this.renderIcon(setting, minX, minY, maxX, maxY);
        }
        this.renderText(setting, minX, minY, maxX, maxY);
    }

    private void renderDummyIcon(EffectSetting setting, int minX, int minY, int maxX, int maxY) {
        Potion potion = Potion.field_76425_a[setting.getEffectId()];
        PotionEffect effect = new PotionEffect(potion.func_76396_c(), 30, 0, false, false);
        this.doRenderIcon(potion, effect, maxX, maxY, minX, minY);
    }

    private void renderIcon(EffectSetting setting, int minX, int minY, int maxX, int maxY) {
        Potion potion = Potion.field_76425_a[setting.getEffectId()];
        PotionEffect effect = this.mc.field_71439_g.func_70660_b(potion);
        this.doRenderIcon(potion, effect, maxX, maxY, minX, minY);
    }

    private void renderText(EffectSetting setting, int minX, int minY, int maxX, int maxY) {
        Potion potion = Potion.field_76425_a[setting.getEffectId()];
        PotionEffect effect = this.mc.field_71439_g.func_70660_b(potion);
        this.doRenderText(setting, potion, effect, maxX, maxY, minX, minY, setting.getTimerColor(), setting.getNameColor(), setting.getNameAttachments());
    }

    private void renderDummyText(EffectSetting setting, int minX, int minY, int maxX, int maxY, int effectTime) {
        Potion potion = Potion.field_76425_a[setting.getEffectId()];
        PotionEffect effect = new PotionEffect(potion.func_76396_c(), effectTime, 0, false, false);
        if (this.mc.field_71462_r instanceof MainMenu && (effect.func_76456_a() == 1 || effect.func_76456_a() == 2)) {
            effect = new PotionEffect(potion.func_76396_c(), effectTime, 1, false, false);
        }
        this.doRenderText(setting, potion, effect, maxX, maxY, minX, minY, setting.getTimerColor(), setting.getNameColor(), setting.getNameAttachments());
    }

    private void renderDummyTextWithOtherColors(EffectSetting setting, EffectSetting syncFrom, int minX, int minY, int maxX, int maxY, int effectTime) {
        Potion potion = Potion.field_76425_a[setting.getEffectId()];
        PotionEffect effect = new PotionEffect(potion.func_76396_c(), effectTime, 0, false, false);
        this.doRenderText(setting, potion, effect, maxX, maxY, minX, minY, syncFrom.getTimerColor(), syncFrom.getNameColor(), syncFrom.getNameAttachments());
    }

    private void doRenderIcon(Potion potion, PotionEffect effect, int maxX, int maxY, int minX, int minY) {
        if (!potion.shouldRenderInvText(effect)) {
            return;
        }
        int x = this.shouldRenderMirrored() ? maxX - 10 : minX;
        int y = minY - 1;
        this.mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/container/inventory.png"));
        int i1 = potion.func_76392_e();
        GlStateManager.func_179094_E();
        float opacity = (float)this.settings.getOpacity() / 255.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddX())), (float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddY())), (float)0.0f);
        GL11.glScalef((float)this.settings.getScale(), (float)this.settings.getScale(), (float)1.0f);
        this.drawTexturedModalRect((int)((double)x + 6.0), (int)((double)y + 7.0), i1 % 8 * 18, 198 + i1 / 8 * 18, 18, 18);
        GL11.glScalef((float)(1.0f / this.settings.getScale()), (float)(1.0f / this.settings.getScale()), (float)1.0f);
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddX()), (float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddY()), (float)0.0f);
        GlStateManager.func_179121_F();
    }

    private void doRenderText(EffectSetting setting, Potion potion, PotionEffect effect, int maxX, int maxY, int minX, int minY, int timerColor, int nameColor, String nameAttachments) {
        int nameX;
        String s1;
        if (!potion.shouldRenderInvText(effect)) {
            return;
        }
        String string = s1 = setting.getCustomName().isEmpty() ? I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]) : setting.getCustomName();
        if (this.settings.isRomanNumerals()) {
            if (effect.func_76458_c() == 1) {
                s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.2", (Object[])new Object[0]);
            } else if (effect.func_76458_c() == 2) {
                s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.3", (Object[])new Object[0]);
            } else if (effect.func_76458_c() == 3) {
                s1 = s1 + " " + I18n.func_135052_a((String)"enchantment.level.4", (Object[])new Object[0]);
            } else if (effect.func_76458_c() > 3 && this.settings.isRenderLevelsAbove4()) {
                s1 = s1 + " " + (effect.func_76458_c() + 1);
            }
        } else {
            s1 = effect.func_76458_c() > 0 ? s1 + " " + (effect.func_76458_c() + 1) : s1;
        }
        String s2 = Potion.func_76389_a((PotionEffect)effect);
        int nameAttchmentsWidth = (setting.isBold() ? setting.getCustomName().length() : 0) + (setting.isItalic() ? 1 : 0);
        int n = this.shouldRenderMirrored() ? maxX - 34 - this.mc.field_71466_p.func_78256_a(s1) - nameAttchmentsWidth : (nameX = minX + (this.settings.isRenderIcons() ? 0 : -20));
        int x = this.shouldRenderMirrored() ? maxX - 34 - this.mc.field_71466_p.func_78256_a(s2) : minX + (this.settings.isRenderIcons() ? 0 : -20);
        int y = minY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddX())), (float)((this.settings.getScale() - 1.0f) * (float)(-this.settings.getAddY())), (float)0.0f);
        GL11.glScalef((float)this.settings.getScale(), (float)this.settings.getScale(), (float)1.0f);
        this.mc.field_71466_p.func_175063_a(nameAttachments + s1, (float)(nameX + 10 + 18), (float)(y + 6), nameColor);
        int offset = this.mc.field_71466_p.field_78288_b + 1;
        this.mc.field_71466_p.func_175063_a(s2, (float)(x + 10 + 18), (float)(y + 6 + offset), timerColor);
        GL11.glScalef((float)(1.0f / this.settings.getScale()), (float)(1.0f / this.settings.getScale()), (float)1.0f);
        GL11.glTranslatef((float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddX()), (float)((this.settings.getScale() - 1.0f) * (float)this.settings.getAddY()), (float)0.0f);
        GlStateManager.func_179121_F();
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181673_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    private int getColorWithAlpha(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private boolean shouldRenderMirrored() {
        ScaledResolution sr = new ScaledResolution(this.mc);
        boolean b1 = sr.func_78326_a() / 2 <= this.settings.getMinX();
        boolean b2 = this.mc.field_71462_r == null || this.mc.field_71462_r instanceof MainMenu;
        return b1 && b2;
    }
}

