/*
 * Decompiled with CFR 0.152.
 */
package me.powns.potionhud.gui.components;

import java.util.ArrayList;
import me.powns.potionhud.PotionHudMod;
import me.powns.potionhud.gui.ButtonYCoords;
import me.powns.potionhud.gui.GuiScreenFactory;
import me.powns.potionhud.settings.EffectSetting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;

public class GuiSidebar {
    public ArrayList<String> pages = new ArrayList();
    public int x;
    public int y;
    public int height;
    public int width;
    public int slotHeight;
    public FontRenderer fontRenderer;
    public int sidebarColor;
    public int selectedIndex = 0;
    public int selectedColor;
    public int textColor;
    private int mouseX;
    private int mouseY;
    private float partialTicks;
    private PotionHudMod mod;
    private EffectSetting setting;
    private ArrayList<ButtonYCoords> buttons;

    public GuiSidebar(int x, int y, int height, int width, int slotHeight, FontRenderer fontRenderer, int sidebarColor, int selectedColor, int textColor, PotionHudMod mod, EffectSetting setting) {
        this.pages.add("Color Settings");
        this.pages.add("Name Settings");
        this.pages.add("Flickering Settings");
        this.pages.add("Import Settings");
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
        this.slotHeight = slotHeight;
        this.fontRenderer = fontRenderer;
        this.sidebarColor = sidebarColor;
        this.selectedColor = selectedColor;
        this.textColor = textColor;
        this.mod = mod;
        this.setting = setting;
    }

    public void setSetting(EffectSetting newSetting) {
        this.setting = newSetting;
    }

    public void drawSidebar(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTicks = partialTicks;
        Gui.func_73734_a((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)this.getColorWithAlpha(this.sidebarColor, 50));
        this.drawPageButtons(this.pages.size() % 2 == 0);
    }

    public void onClick(int mouseX, int mouseY) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonYCoords current = this.buttons.get(i);
            if (mouseY <= current.getStartY() || mouseY >= current.getEndY() || mouseX <= this.x || mouseX >= this.width) continue;
            this.selectedIndex = i;
            this.buttonClicked();
            return;
        }
    }

    private void buttonClicked() {
        Minecraft.func_71410_x().func_147108_a(GuiScreenFactory.getScreenInstance(this.selectedIndex, this.mod, this.setting, this));
    }

    private void drawPageButtons(boolean evenAmount) {
        this.buttons = new ArrayList();
        int startHeight = 0;
        startHeight = evenAmount ? this.height / 2 - this.pages.size() / 2 * this.slotHeight : this.height / 2 - this.pages.size() / 2 * this.slotHeight + this.slotHeight / 2;
        this.buttons = this.drawButtons(startHeight);
    }

    private ArrayList<ButtonYCoords> drawButtons(int startHeight) {
        ArrayList<ButtonYCoords> result = new ArrayList<ButtonYCoords>();
        for (int i = 0; i < this.pages.size(); ++i) {
            int y = startHeight + this.slotHeight * i;
            if (i == this.selectedIndex) {
                Gui.func_73734_a((int)this.x, (int)y, (int)this.width, (int)(y + this.slotHeight), (int)this.getColorWithAlpha(this.selectedColor, 255));
            }
            this.fontRenderer.func_175063_a(this.pages.get(i), (float)(this.x + 5), (float)(y + this.slotHeight / 2 - this.fontRenderer.field_78288_b / 2), this.textColor);
            result.add(new ButtonYCoords(y, y + this.slotHeight, this.pages.get(i)));
        }
        return result;
    }

    private int getColorWithAlpha(int rgb, int a) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }
}

