/*
 * Decompiled with CFR 0.152.
 */
package me.powns.potionhud.gui.menu.effectsettings;

import java.io.IOException;
import me.powns.potionhud.PotionHudMod;
import me.powns.potionhud.gui.components.GuiSidebar;
import me.powns.potionhud.gui.components.GuiSlideControl;
import me.powns.potionhud.gui.components.GuiTransButton;
import me.powns.potionhud.gui.components.GuiTransTextField;
import me.powns.potionhud.gui.menu.EditorMenu;
import me.powns.potionhud.settings.EffectSetting;
import me.powns.potionhud.settings.Settings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class EffectFlickerMenu
extends GuiScreen {
    private PotionHudMod mod;
    private EffectSetting setting;
    private Settings s;
    private GuiSlideControl sliderFlickerSpeed;
    private GuiTransTextField timeText;
    private GuiSidebar sidebar;

    public EffectFlickerMenu(PotionHudMod mod, EffectSetting setting, Settings s, GuiSidebar sidebar) {
        this.mod = mod;
        this.s = s;
        this.setting = setting;
        this.sidebar = sidebar;
    }

    public void func_73866_w_() {
        if (this.sidebar == null) {
            this.sidebar = new GuiSidebar(0, 0, this.field_146295_m, this.field_146294_l / 5 + 20, 25, this.field_146289_q, 8168374, 8103095, -1, this.mod, this.setting);
        }
        this.sidebar.height = this.field_146295_m;
        this.sidebar.width = this.field_146294_l / 5 + 20;
        this.timeText = new GuiTransTextField(this.field_146289_q, this.getCenter() - 18, this.getRowPos(4), 40, 20);
        this.timeText.setMaxStringLength(23);
        this.timeText.setText("" + this.setting.getFlickerStartTime());
        this.timeText.setFocused(false);
        this.sliderFlickerSpeed = new GuiSlideControl(13, this.getCenter() - 75, this.getRowPos(5), 150, 20, "Flicker time: ", 10.0f, 20.0f, this.setting.getFlickerSpeed(), true);
        this.field_146292_n.add(this.sliderFlickerSpeed);
        this.field_146292_n.add(new GuiTransButton(12, this.getCenter() - 75, this.getRowPos(3), 150, 20, (this.setting.isFlickerWhenLow() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + "Low duration flickering"));
        this.field_146292_n.add(new GuiTransButton(5, this.getCenter() - 75, this.getRowPos(8), 150, 20, "Save"));
        this.sliderFlickerSpeed.field_146125_m = this.setting.isFlickerWhenLow();
    }

    public int getRowPos(int rowNumber) {
        return this.field_146295_m / 4 + (24 * rowNumber - 24) - 16;
    }

    public int getCenter() {
        return (this.field_146294_l + this.sidebar.width) / 2;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        this.sidebar.drawSidebar(mouseX, mouseY, partialTicks);
        GL11.glColor3f((float)255.0f, (float)255.0f, (float)255.0f);
        this.mod.getRenderer().renderSingleCustomCoords(this.setting, this.getCenter() - 55 + 16, this.getRowPos(-1) + 10);
        this.func_73732_a(this.field_146297_k.field_71466_p, "Flickering Settings", this.getCenter(), this.getRowPos(2), this.setting.getNameColor());
        if (this.setting.isFlickerWhenLow()) {
            this.timeText.drawTextBox();
            this.func_73731_b(this.field_146297_k.field_71466_p, "Starts at", this.getCenter() - 68, this.getRowPos(4) + this.field_146297_k.field_71466_p.field_78288_b / 2 + 1, -1);
            this.func_73731_b(this.field_146297_k.field_71466_p, "seconds", this.getCenter() + 27, this.getRowPos(4) + this.field_146297_k.field_71466_p.field_78288_b / 2 + 1, -1);
        }
        this.updateSettings();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        GuiTransTextField target = this.timeText;
        if (mouseX > target.xPosition && mouseX < target.xPosition + target.width && mouseY > target.yPosition && mouseY < target.yPosition + target.height && this.timeText.getVisible()) {
            this.timeText.mouseClicked(mouseX, mouseY, mouseButton);
        } else {
            this.timeText.setFocused(false);
        }
        if (mouseButton == 0) {
            this.sidebar.onClick(mouseX, mouseY);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.sliderFlickerSpeed.isSliding = false;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 5: {
                this.field_146297_k.func_147108_a((GuiScreen)new EditorMenu(this.mod, this.s));
                break;
            }
            case 12: {
                this.setting.setFlickerWhenLow(!this.setting.isFlickerWhenLow());
                button.field_146126_j = (this.setting.isFlickerWhenLow() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED) + "Low duration flickering";
                this.sliderFlickerSpeed.field_146125_m = this.setting.isFlickerWhenLow();
            }
        }
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        block2: {
            super.func_73869_a(par1, par2);
            try {
                Integer.parseInt("" + par1);
                this.timeText.textboxKeyTyped(par1, par2);
            }
            catch (Exception ex) {
                if (!("" + par1).equals("\b")) break block2;
                this.timeText.textboxKeyTyped(par1, par2);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.timeText.updateCursorCounter();
    }

    private void updateSettings() {
        this.setting.setFlickerSpeed(this.sliderFlickerSpeed.GetValueAsInt());
        if (!this.timeText.getText().isEmpty()) {
            this.setting.setFlickerStartTime(Integer.parseInt(this.timeText.getText()));
        } else {
            this.setting.setFlickerStartTime(0);
        }
    }

    public void func_146281_b() {
        this.s.saveConfig();
    }

    public boolean func_73868_f() {
        return false;
    }
}

