/*
 * Decompiled with CFR 0.152.
 */
package me.powns.directionhud.gui;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiSlideControl
extends GuiButton {
    public String label;
    public float curValue;
    public float minValue;
    public float maxValue;
    public boolean isSliding;
    public boolean useIntegers;
    private static DecimalFormat numFormat = new DecimalFormat("#.00");

    public GuiSlideControl(int id, int x, int y, int width, int height, String displayString, float minVal, float maxVal, float curVal, boolean useInts) {
        super(id, x, y, width, height, useInts ? displayString + (int)curVal : displayString + numFormat.format(curVal));
        this.label = displayString;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.curValue = (curVal - minVal) / (maxVal - minVal);
        this.useIntegers = useInts;
    }

    public float GetValueAsFloat() {
        return (this.maxValue - this.minValue) * this.curValue + this.minValue;
    }

    public int GetValueAsInt() {
        return (int)((this.maxValue - this.minValue) * this.curValue + this.minValue);
    }

    public String GetLabel() {
        if (this.useIntegers) {
            return this.label + this.GetValueAsInt();
        }
        return this.label + numFormat.format(this.GetValueAsFloat());
    }

    protected void SetLabel() {
        this.field_146126_j = this.GetLabel();
    }

    public int func_146114_a(boolean isMouseOver) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mousePosX, int mousePosY) {
        if (this.field_146125_m) {
            if (this.isSliding) {
                this.curValue = ((float)mousePosX - ((float)this.field_146128_h + 4.0f)) / ((float)this.field_146120_f - 8.0f);
                if (this.curValue < 0.0f) {
                    this.curValue = 0.0f;
                }
                if (this.curValue > 1.0f) {
                    this.curValue = 1.0f;
                }
                this.SetLabel();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.curValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.curValue * (float)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mousePosX, int mousePosY) {
        if (!super.func_146116_c(mc, mousePosX, mousePosY)) {
            return false;
        }
        this.curValue = ((float)mousePosX - ((float)this.field_146128_h + 4.0f)) / ((float)this.field_146120_f - 8.0f);
        if (this.curValue < 0.0f) {
            this.curValue = 0.0f;
        }
        if (this.curValue > 1.0f) {
            this.curValue = 1.0f;
        }
        this.SetLabel();
        if (this.isSliding) {
            this.isSliding = false;
            return false;
        }
        this.isSliding = true;
        return true;
    }

    public void func_146118_a(int mousePosX, int mousePosY) {
        this.isSliding = false;
    }
}

