/*
 * Decompiled with CFR 0.152.
 */
package me.powns.directionhud.gui;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import me.powns.directionhud.gui.MainSettingsGui;
import me.powns.directionhud.gui.ModuleSettingsGui;
import me.powns.directionhud.gui.SettingsGui;
import me.powns.directionhud.settings.PrefixStyle;
import me.powns.directionhud.settings.Settings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class HudRenderer {
    private Settings settings;
    private Minecraft mc;
    private String[] directions;

    public HudRenderer(Settings settings) {
        this.settings = settings;
        this.mc = Minecraft.func_71410_x();
        this.directions = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    }

    @SubscribeEvent
    public void onRenderEvent(TickEvent.RenderTickEvent e) throws IOException {
        boolean showInChat;
        boolean bl = showInChat = this.settings.isShowInChat() && this.mc.field_71456_v.func_146158_b().func_146241_e();
        if (this.settings.isEnabled() && this.mc.field_71441_e != null && (this.mc.field_71462_r == null || this.mc.field_71462_r instanceof MainSettingsGui || this.mc.field_71462_r instanceof SettingsGui || this.mc.field_71462_r instanceof ModuleSettingsGui || showInChat) && !this.mc.field_71474_y.field_74330_P) {
            int minX = this.settings.addX;
            int minY = this.settings.addY;
            int maxX = this.settings.addX + this.mc.field_71466_p.func_78256_a(this.getPrefix("X") + "300000000  ") + this.settings.decimals * 4;
            int maxY = this.settings.isVerticalMode() ? this.settings.addY + 6 + this.mc.field_71466_p.field_78288_b * (this.settings.isBiomeName() ? 4 : 3) : this.settings.addY + 6 + this.mc.field_71466_p.field_78288_b;
            this.renderHud(minX, minY, maxX, maxY);
            this.settings.minX = minX;
            this.settings.minY = minY;
            this.settings.maxX = maxX;
            this.settings.maxY = maxY;
            if (this.mc.field_71462_r != null) {
                this.mc.field_71462_r.func_146269_k();
            }
        }
    }

    public void renderHud(int minX, int minY, int maxX, int maxY) {
        DecimalFormat dm = this.settings.getFormat();
        EntityPlayerSP p = this.mc.field_71439_g;
        GL11.glTranslatef((float)((this.settings.scale - 1.0f) * (float)(-minX)), (float)((this.settings.scale - 1.0f) * (float)(-minY)), (float)0.0f);
        GL11.glScalef((float)this.settings.scale, (float)this.settings.scale, (float)1.0f);
        if (this.settings.isVerticalMode()) {
            Gui.func_73734_a((int)minX, (int)minY, (int)(maxX + this.getPrefixSize() - 7 + (PrefixStyle.values()[this.settings.prefixStyle] == PrefixStyle.NONE ? 12 : 0)), (int)maxY, (int)this.settings.getBackgroundColor());
            this.drawStringModified(this.getPrefix("X"), minX + 2, minY + 3, this.settings.getPrefixColor());
            this.drawStringModified(this.getPrefix("Y"), minX + 2, minY + 3 + this.mc.field_71466_p.field_78288_b, this.settings.getPrefixColor());
            this.drawStringModified(this.getPrefix("Z"), minX + 2, minY + 3 + this.mc.field_71466_p.field_78288_b * 2, this.settings.getPrefixColor());
            this.drawStringModified("" + this.formatDouble(p.field_70165_t), minX + 2 + this.getPrefixSize(), minY + 3, this.settings.getTextColor());
            this.drawStringModified("" + this.formatDouble(p.field_70163_u), minX + 2 + this.getPrefixSize(), minY + 3 + this.mc.field_71466_p.field_78288_b, this.settings.getTextColor());
            this.drawStringModified("" + this.formatDouble(p.field_70161_v), minX + 2 + this.getPrefixSize(), minY + 3 + this.mc.field_71466_p.field_78288_b * 2, this.settings.getTextColor());
            if (this.settings.isBiomeName()) {
                this.drawStringModified(this.getBiomeName(p), minX + 2, minY + 5 + this.mc.field_71466_p.field_78288_b * 3, this.settings.getBiomeNameColor());
            }
            if (this.settings.isDirection()) {
                this.drawStringModified(this.getDirection(), minX + 50 + this.getPrefixSize() + this.settings.decimals * 4, minY + 3 + this.mc.field_71466_p.field_78288_b * 1, this.settings.getDirectionColor());
                if (this.settings.isSkinFaceDirection() && this.settings.isDirection()) {
                    this.drawFace(minX + 40 + this.getPrefixSize() + this.settings.decimals * 4, minY + 3 + this.mc.field_71466_p.field_78288_b * 1);
                }
            }
        } else {
            switch (PrefixStyle.values()[this.settings.prefixStyle]) {
                case REGULAR: {
                    this.drawStringModified("( ", minX + 2, minY + 3, this.settings.getTextColor());
                    this.drawStringModified(this.getPrefix("X"), minX + 9, minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Y"), minX + 3 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Z"), minX + 4 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70165_t) + ",", minX + 8 + this.getPrefixSize(), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70163_u) + ",", minX + 14 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70161_v), minX + 15 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified(" )", minX + 4 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getTextColor());
                    if (!this.settings.isDirection()) break;
                    this.drawStringModified(this.getDirection(), minX + 16 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getDirectionColor());
                    break;
                }
                case PARANTHESES: {
                    this.drawStringModified("( ", minX + 2, minY + 3, this.settings.getTextColor());
                    this.drawStringModified(this.getPrefix("X"), minX + 9, minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Y"), minX + 3 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Z"), minX + 2 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70165_t) + ",", minX + 8 + this.getPrefixSize(), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70163_u) + ",", minX + 22 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70161_v), minX + 21 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified(" )", minX + 2 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getTextColor());
                    if (!this.settings.isDirection()) break;
                    this.drawStringModified(this.getDirection(), minX + 15 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getDirectionColor());
                    break;
                }
                case SQ_BRACKETS: {
                    this.drawStringModified("( ", minX + 2, minY + 3, this.settings.getTextColor());
                    this.drawStringModified(this.getPrefix("X"), minX + 9, minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Y"), minX + 3 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified(this.getPrefix("Z"), minX + 2 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getPrefixColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70165_t) + ",", minX + 8 + this.getPrefixSize(), minY + 3, this.settings.textColor);
                    this.drawStringModified("" + this.formatDouble(p.field_70163_u) + ",", minX + 20 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70161_v), minX + 18 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified(" )", minX + 1 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getTextColor());
                    if (!this.settings.isDirection()) break;
                    this.drawStringModified(this.getDirection(), minX + 13 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getDirectionColor());
                    break;
                }
                case NONE: {
                    this.drawStringModified("( ", minX + 2, minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70165_t) + ",", minX + 8 + this.getPrefixSize(), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70163_u) + ",", minX + 2 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified("" + this.formatDouble(p.field_70161_v), minX + 1 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + " " + this.getPrefix("Y") + this.formatDouble(p.field_70163_u)), minY + 3, this.settings.getTextColor());
                    this.drawStringModified(" )", minX + 2 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getTextColor());
                    if (!this.settings.isDirection()) break;
                    this.drawStringModified(this.getDirection(), minX + 12 + this.mc.field_71466_p.func_78256_a("( " + this.getPrefix("X") + this.formatDouble(p.field_70165_t) + "" + this.getPrefix("Y") + this.formatDouble(p.field_70163_u) + "" + this.getPrefix("Z") + this.formatDouble(p.field_70161_v)), minY + 3, this.settings.getDirectionColor());
                }
            }
        }
        GL11.glScalef((float)(1.0f / this.settings.scale), (float)(1.0f / this.settings.scale), (float)1.0f);
        GL11.glTranslatef((float)((this.settings.scale - 1.0f) * (float)minX), (float)((this.settings.scale - 1.0f) * (float)minY), (float)0.0f);
    }

    private int getPrefixSize() {
        return this.mc.field_71466_p.func_78256_a(this.getPrefix("X"));
    }

    private String formatDouble(double value) {
        if (this.settings.decimals <= 0) {
            return "" + new DecimalFormat("##").format(value);
        }
        BigDecimal bd = new BigDecimal(Double.toString(value));
        bd = bd.setScale(this.settings.decimals, RoundingMode.HALF_UP);
        return "" + bd.doubleValue();
    }

    private String getPrefix(String coordinateLetter) {
        String result = coordinateLetter + ": ";
        switch (PrefixStyle.values()[this.settings.prefixStyle]) {
            case REGULAR: {
                result = coordinateLetter + ": ";
                break;
            }
            case PARANTHESES: {
                result = "(" + coordinateLetter + ") ";
                break;
            }
            case SQ_BRACKETS: {
                result = "[" + coordinateLetter + "] ";
                break;
            }
            case NONE: {
                result = "";
            }
        }
        return result;
    }

    private void drawFace(int x, int y) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)255.0f, (float)255.0f, (float)255.0f, (float)255.0f);
        float scale = 2.0f;
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glScalef((float)scale, (float)scale, (float)0.1f);
        this.mc.field_71446_o.func_110577_a(this.mc.field_71439_g.func_110306_p());
        Gui.func_146110_a((int)x, (int)y, (float)36.0f, (float)260.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        Gui.func_146110_a((int)x, (int)y, (float)20.0f, (float)260.0f, (int)4, (int)4, (float)32.0f, (float)32.0f);
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    private void drawStringModified(String text, int minX, int minY, int color) {
        boolean shadow = this.settings.isShadowedText();
        if (shadow) {
            this.mc.field_71466_p.func_175063_a(text, (float)minX, (float)minY, color);
            return;
        }
        this.mc.field_71466_p.func_78276_b(text, minX, minY, color);
    }

    private String getBiomeName(EntityPlayerSP p) {
        BlockPos pos = new BlockPos(p.field_70165_t, p.field_70163_u, p.field_70161_v);
        return this.mc.field_71441_e.func_180494_b((BlockPos)pos).field_76791_y;
    }

    private String getDirection() {
        int yaw;
        for (yaw = (int)(this.mc.field_71439_g.func_70079_am() + 180.0f); yaw < 0; yaw += 360) {
        }
        int partSize = 360 / this.directions.length;
        int index = (yaw + partSize / 2) / partSize;
        return this.directions[index % this.directions.length];
    }
}

