/*
 * Decompiled with CFR 0.152.
 */
package me.powns.armorhud.gui;

import java.text.DecimalFormat;
import me.powns.armorhud.ArmorHud;
import me.powns.armorhud.settings.SettingsManager;
import me.powns.armorhud.settings.modules.BootsSettings;
import me.powns.armorhud.settings.modules.ChestplateSettings;
import me.powns.armorhud.settings.modules.HeldItemSettings;
import me.powns.armorhud.settings.modules.HelmetSettings;
import me.powns.armorhud.settings.modules.LeggingsSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class HudRenderer {
    private ArmorHud mod;
    private Minecraft mc;
    private SettingsManager sm;

    public HudRenderer(ArmorHud mod, SettingsManager sm) {
        this.mod = mod;
        this.mc = Minecraft.func_71410_x();
        this.sm = sm;
    }

    public void renderHud() {
        if (this.sm.getHelmetSettings().isShown()) {
            this.renderHelmet();
        }
        if (this.sm.getChestplateSettings().isShown()) {
            this.renderChestplate();
        }
        if (this.sm.getLeggingsSettings().isShown()) {
            this.renderLeggings();
        }
        if (this.sm.getBootsSettings().isShown()) {
            this.renderBoots();
        }
        if (this.sm.getHelditemSettings().isShown()) {
            this.renderHeldItem();
        }
    }

    private void renderHelmet() {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(3) != null) {
            ItemStack is = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(3);
            HelmetSettings settings = this.sm.getHelmetSettings();
            int stringWidth = this.mc.field_71466_p.func_78256_a(this.getDuraString(is));
            this.drawItem(is, settings.getMinX(), settings.getMinY());
            this.mc.field_71466_p.func_175063_a(this.getDuraString(is), !this.sm.getGlobalSettings().isDuraToTheRight() ? (float)(settings.getMinX() - stringWidth) : (float)(settings.getMinX() + 16), (float)(settings.getMinY() + 5), settings.getDuraColor(this.getDuraStringColorCat(is)));
        }
    }

    private void renderChestplate() {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(2) != null) {
            ItemStack is = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(2);
            ChestplateSettings settings = this.sm.getChestplateSettings();
            int stringWidth = this.mc.field_71466_p.func_78256_a(this.getDuraString(is));
            this.drawItem(is, settings.getMinX(), settings.getMinY());
            this.mc.field_71466_p.func_175063_a(this.getDuraString(is), !this.sm.getGlobalSettings().isDuraToTheRight() ? (float)(settings.getMinX() - stringWidth) : (float)(settings.getMinX() + 16), (float)(settings.getMinY() + 5), settings.getDuraColor(this.getDuraStringColorCat(is)));
        }
    }

    private void renderLeggings() {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(1) != null) {
            ItemStack is = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(1);
            LeggingsSettings settings = this.sm.getLeggingsSettings();
            int stringWidth = this.mc.field_71466_p.func_78256_a(this.getDuraString(is));
            this.drawItem(is, settings.getMinX(), settings.getMinY());
            this.mc.field_71466_p.func_175063_a(this.getDuraString(is), !this.sm.getGlobalSettings().isDuraToTheRight() ? (float)(settings.getMinX() - stringWidth) : (float)(settings.getMinX() + 16), (float)(settings.getMinY() + 5), settings.getDuraColor(this.getDuraStringColorCat(is)));
        }
    }

    private void renderBoots() {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(0) != null) {
            ItemStack is = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(0);
            BootsSettings settings = this.sm.getBootsSettings();
            int stringWidth = this.mc.field_71466_p.func_78256_a(this.getDuraString(is));
            this.drawItem(is, settings.getMinX(), settings.getMinY());
            this.mc.field_71466_p.func_175063_a(this.getDuraString(is), !this.sm.getGlobalSettings().isDuraToTheRight() ? (float)(settings.getMinX() - stringWidth) : (float)(settings.getMinX() + 16), (float)(settings.getMinY() + 5), settings.getDuraColor(this.getDuraStringColorCat(is)));
        }
    }

    private void renderHeldItem() {
        if (Minecraft.func_71410_x().field_71439_g.field_71071_by != null && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g() != null) {
            ItemStack is = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g();
            HeldItemSettings settings = this.sm.getHelditemSettings();
            int stringWidth = this.mc.field_71466_p.func_78256_a(this.getDuraString(is));
            this.drawItem(is, settings.getMinX(), settings.getMinY());
            this.mc.field_71466_p.func_175063_a(this.getDuraString(is), !this.sm.getGlobalSettings().isDuraToTheRight() ? (float)(settings.getMinX() - stringWidth) : (float)(settings.getMinX() + 16), (float)(settings.getMinY() + 5), settings.getDuraColor(this.getDuraStringColorCat(is)));
        }
    }

    public void centerHorizontal() {
        int helmetX = this.sm.getHelmetSettings().getMinX();
        int helmetY = this.sm.getHelmetSettings().getMinY();
        HelmetSettings helmet = this.sm.getHelmetSettings();
        ChestplateSettings chestplate = this.sm.getChestplateSettings();
        LeggingsSettings leggings = this.sm.getLeggingsSettings();
        BootsSettings boots = this.sm.getBootsSettings();
        HeldItemSettings helditem = this.sm.getHelditemSettings();
        switch (this.sm.getGlobalSettings().getCurrentDuraMode()) {
            case NONE: {
                chestplate.setAddX(helmetX + 15);
                chestplate.setAddY(helmetY);
                leggings.setAddX(helmetX + 30);
                leggings.setAddY(helmetY);
                boots.setAddX(helmetX + 45);
                boots.setAddY(helmetY);
                helditem.setAddX(helmetX + 63);
                helditem.setAddY(helmetY);
                break;
            }
            case REGULAR: {
                chestplate.setAddX(helmetX + 37);
                chestplate.setAddY(helmetY);
                leggings.setAddX(helmetX + 72);
                leggings.setAddY(helmetY);
                boots.setAddX(helmetX + 107);
                boots.setAddY(helmetY);
                helditem.setAddX(helmetX + 144);
                helditem.setAddY(helmetY);
                break;
            }
            case PERCENTAGE: {
                chestplate.setAddX(helmetX + 52);
                chestplate.setAddY(helmetY);
                leggings.setAddX(helmetX + 102);
                leggings.setAddY(helmetY);
                boots.setAddX(helmetX + 152);
                boots.setAddY(helmetY);
                helditem.setAddX(helmetX + 202);
                helditem.setAddY(helmetY);
                break;
            }
            case COMPARED: {
                chestplate.setAddX(helmetX + 62);
                chestplate.setAddY(helmetY);
                leggings.setAddX(helmetX + 122);
                leggings.setAddY(helmetY);
                boots.setAddX(helmetX + 182);
                boots.setAddY(helmetY);
                helditem.setAddX(helmetX + 242);
                helditem.setAddY(helmetY);
                break;
            }
        }
    }

    public void centerVertical() {
        int helmetX = this.sm.getHelmetSettings().getMinX();
        int helmetY = this.sm.getHelmetSettings().getMinY();
        HelmetSettings helmet = this.sm.getHelmetSettings();
        ChestplateSettings chestplate = this.sm.getChestplateSettings();
        LeggingsSettings leggings = this.sm.getLeggingsSettings();
        BootsSettings boots = this.sm.getBootsSettings();
        HeldItemSettings helditem = this.sm.getHelditemSettings();
        chestplate.setAddX(helmetX);
        chestplate.setAddY(helmetY + 13);
        leggings.setAddX(helmetX);
        leggings.setAddY(helmetY + 27);
        boots.setAddX(helmetX);
        boots.setAddY(helmetY + 40);
        helditem.setAddX(helmetX);
        helditem.setAddY(helmetY + 56);
    }

    public void drawItem(ItemStack is, int x, int y) {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        int count = is.field_77994_a;
        String amountToDisplay = "" + (count > 1 ? Integer.valueOf(count) : "");
        this.mc.func_175599_af().func_180450_b(is, x, y);
        if (this.sm.getGlobalSettings().isRenderOverlay()) {
            this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, is, x, y, amountToDisplay);
        } else {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            this.mc.field_71466_p.func_175063_a(amountToDisplay, (float)(x + 19 - 2 - this.mc.field_71466_p.func_78256_a(amountToDisplay)), (float)(y + 6 + 3), 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GL11.glPopMatrix();
    }

    private int getDuraStringColorCat(ItemStack is) {
        double dmg;
        double max = is.func_77958_k();
        double percentage = (max - (dmg = (double)is.func_77952_i())) / max * 100.0;
        if (percentage <= 100.0 && percentage > 75.0) {
            return 1;
        }
        if (percentage < 75.0 && percentage >= 50.0) {
            return 2;
        }
        if (percentage < 50.0 && percentage >= 25.0) {
            return 3;
        }
        if (percentage < 25.0 && percentage >= 0.0) {
            return 4;
        }
        return -1;
    }

    private String getDuraString(ItemStack is) {
        String result = "";
        if (is.func_77958_k() > 0) {
            switch (this.sm.getGlobalSettings().getCurrentDuraMode()) {
                case REGULAR: {
                    result = "" + (is.func_77958_k() - is.func_77952_i());
                    break;
                }
                case PERCENTAGE: {
                    DecimalFormat formatter = new DecimalFormat("#0.00");
                    double max = is.func_77958_k();
                    double dmg = is.func_77952_i();
                    double percentage = (max - dmg) / max * 100.0;
                    result = percentage == 100.0 ? "100%" : formatter.format(percentage) + "%";
                    break;
                }
                case COMPARED: {
                    result = "" + (is.func_77958_k() - is.func_77952_i()) + "/" + is.func_77958_k();
                    break;
                }
            }
        }
        return result;
    }
}

