/*
 * Decompiled with CFR 0.152.
 */
package me.powns.armorhud.gui.menus;

import java.io.IOException;
import java.util.ArrayList;
import me.powns.armorhud.ArmorHud;
import me.powns.armorhud.gui.menus.ModulesMenuGui;
import me.powns.armorhud.settings.GlobalSettings;
import me.powns.armorhud.settings.SettingsManager;
import me.powns.armorhud.settings.modules.BootsSettings;
import me.powns.armorhud.settings.modules.ChestplateSettings;
import me.powns.armorhud.settings.modules.HeldItemSettings;
import me.powns.armorhud.settings.modules.HelmetSettings;
import me.powns.armorhud.settings.modules.LeggingsSettings;
import me.powns.armorhud.utils.GuiSlideControl;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class DuraColorMenuGui
extends GuiScreen {
    private ArmorHud mod;
    private SettingsManager sm;
    private GlobalSettings global;
    private int module;
    private int cat;
    private String[] modules;
    private String[] duras;
    private GuiButton nextCat;
    private GuiButton prevCat;
    private GuiButton chroma;
    private GuiButton goBack;
    private GuiSlideControl red;
    private GuiSlideControl green;
    private GuiSlideControl blue;
    private Object theSettings;

    public DuraColorMenuGui(ArmorHud mod, int module) {
        this.mod = mod;
        this.sm = this.mod.getSm();
        this.global = this.sm.getGlobalSettings();
        this.module = module;
        this.cat = 1;
        this.modules = new String[]{"Helmet", "Chestplate", "Leggings", "Boots", "Held Item"};
        this.duras = new String[]{"100% - 75%", "75% - 50%", "50% - 25%", "25% - 0%"};
        this.setTheSettings();
    }

    public void func_73866_w_() {
        this.setTheSettings();
        ArrayList<Integer> rgb = this.getRGBVals();
        this.chroma = new GuiButton(5, this.getCenter() - 75, this.getRowPos(3), 150, 20, "Chroma: " + this.getStateLabel(this.isChroma()));
        this.field_146292_n.add(this.chroma);
        this.nextCat = new GuiButton(0, this.getCenter() + 90, this.getRowPos(5), 20, 20, ">");
        this.field_146292_n.add(this.nextCat);
        this.prevCat = new GuiButton(1, this.getCenter() - 110, this.getRowPos(5), 20, 20, "<");
        this.field_146292_n.add(this.prevCat);
        this.red = new GuiSlideControl(2, this.getCenter() - 75, this.getRowPos(4), 150, 20, "Red: ", 0.0f, 255.0f, rgb.get(0).intValue(), true);
        this.green = new GuiSlideControl(3, this.getCenter() - 75, this.getRowPos(5), 150, 20, "Green: ", 0.0f, 255.0f, rgb.get(1).intValue(), true);
        this.blue = new GuiSlideControl(4, this.getCenter() - 75, this.getRowPos(6), 150, 20, "Blue: ", 0.0f, 255.0f, rgb.get(2).intValue(), true);
        this.goBack = new GuiButton(6, this.getCenter() - 75, this.getRowPos(8), 150, 20, "Return");
        this.field_146292_n.add(this.goBack);
        this.field_146292_n.add(this.red);
        this.field_146292_n.add(this.green);
        this.field_146292_n.add(this.blue);
    }

    public int getRowPos(int rowNumber) {
        return this.field_146295_m / 4 + (24 * rowNumber - 24) - 16;
    }

    public int getCenter() {
        return this.field_146294_l / 2;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        switch (button.field_146127_k) {
            case 0: {
                this.cat = this.cat + 1 > 4 ? 1 : ++this.cat;
                this.field_146297_k.func_147108_a((GuiScreen)this);
                break;
            }
            case 1: {
                this.cat = this.cat - 1 < 1 ? 4 : --this.cat;
                this.field_146297_k.func_147108_a((GuiScreen)this);
                break;
            }
            case 5: {
                this.toggleChroma();
                button.field_146126_j = "Chroma: " + this.getStateLabel(this.isChroma());
                break;
            }
            case 6: {
                this.field_146297_k.func_147108_a((GuiScreen)new ModulesMenuGui(this.mod));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_146276_q_();
        int duraPrevColor = this.getColor();
        this.func_73732_a(this.field_146297_k.field_71466_p, this.modules[this.module - 1] + " settings", this.getCenter(), this.getRowPos(1), -1);
        this.func_73732_a(this.field_146297_k.field_71466_p, "Durability: " + (this.isChroma() ? "Chroma" : this.duras[this.cat - 1]), this.getCenter(), this.getRowPos(2), duraPrevColor);
        this.updateColors();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private String getStateLabel(boolean bool) {
        if (bool) {
            return "Enabled";
        }
        return "Disabled";
    }

    private void toggleChroma() {
        switch (this.module) {
            case 1: {
                HelmetSettings settings = (HelmetSettings)this.theSettings;
                settings.setChroma(!settings.isChroma());
                break;
            }
            case 2: {
                ChestplateSettings settings = (ChestplateSettings)this.theSettings;
                settings.setChroma(!settings.isChroma());
                break;
            }
            case 3: {
                LeggingsSettings settings = (LeggingsSettings)this.theSettings;
                settings.setChroma(!settings.isChroma());
                break;
            }
            case 4: {
                BootsSettings settings = (BootsSettings)this.theSettings;
                settings.setChroma(!settings.isChroma());
                break;
            }
            case 5: {
                HeldItemSettings settings = (HeldItemSettings)this.theSettings;
                settings.setChroma(!settings.isChroma());
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean isChroma() {
        switch (this.module) {
            case 1: {
                HelmetSettings settings = (HelmetSettings)this.theSettings;
                return settings.isChroma();
            }
            case 2: {
                ChestplateSettings settings = (ChestplateSettings)this.theSettings;
                return settings.isChroma();
            }
            case 3: {
                LeggingsSettings settings = (LeggingsSettings)this.theSettings;
                return settings.isChroma();
            }
            case 4: {
                BootsSettings settings = (BootsSettings)this.theSettings;
                return settings.isChroma();
            }
            case 5: {
                HeldItemSettings settings = (HeldItemSettings)this.theSettings;
                return settings.isChroma();
            }
        }
        return false;
    }

    private void updateColors() {
        switch (this.module) {
            case 1: {
                HelmetSettings settings = (HelmetSettings)this.theSettings;
                settings.setDuraColor(this.cat, this.red.GetValueAsInt(), this.green.GetValueAsInt(), this.blue.GetValueAsInt());
                break;
            }
            case 2: {
                ChestplateSettings settings = (ChestplateSettings)this.theSettings;
                settings.setDuraColor(this.cat, this.red.GetValueAsInt(), this.green.GetValueAsInt(), this.blue.GetValueAsInt());
                break;
            }
            case 3: {
                LeggingsSettings settings = (LeggingsSettings)this.theSettings;
                settings.setDuraColor(this.cat, this.red.GetValueAsInt(), this.green.GetValueAsInt(), this.blue.GetValueAsInt());
                break;
            }
            case 4: {
                BootsSettings settings = (BootsSettings)this.theSettings;
                settings.setDuraColor(this.cat, this.red.GetValueAsInt(), this.green.GetValueAsInt(), this.blue.GetValueAsInt());
                break;
            }
            case 5: {
                HeldItemSettings settings = (HeldItemSettings)this.theSettings;
                settings.setDuraColor(this.cat, this.red.GetValueAsInt(), this.green.GetValueAsInt(), this.blue.GetValueAsInt());
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setTheSettings() {
        switch (this.module) {
            case 1: {
                this.theSettings = this.sm.getHelmetSettings();
                break;
            }
            case 2: {
                this.theSettings = this.sm.getChestplateSettings();
                break;
            }
            case 3: {
                this.theSettings = this.sm.getLeggingsSettings();
                break;
            }
            case 4: {
                this.theSettings = this.sm.getBootsSettings();
                break;
            }
            case 5: {
                this.theSettings = this.sm.getHelditemSettings();
                break;
            }
            default: {
                this.theSettings = null;
            }
        }
    }

    private int getColor() {
        switch (this.module) {
            case 1: {
                HelmetSettings settings = (HelmetSettings)this.theSettings;
                return settings.getDuraColor(this.cat);
            }
            case 2: {
                ChestplateSettings settings = (ChestplateSettings)this.theSettings;
                return settings.getDuraColor(this.cat);
            }
            case 3: {
                LeggingsSettings settings = (LeggingsSettings)this.theSettings;
                return settings.getDuraColor(this.cat);
            }
            case 4: {
                BootsSettings settings = (BootsSettings)this.theSettings;
                return settings.getDuraColor(this.cat);
            }
            case 5: {
                HeldItemSettings settings = (HeldItemSettings)this.theSettings;
                return settings.getDuraColor(this.cat);
            }
        }
        return -1;
    }

    private ArrayList<Integer> getRGBVals() {
        switch (this.module) {
            case 1: {
                HelmetSettings settings = (HelmetSettings)this.theSettings;
                return settings.getDuraRGBValues(this.cat);
            }
            case 2: {
                ChestplateSettings settings = (ChestplateSettings)this.theSettings;
                return settings.getDuraRGBValues(this.cat);
            }
            case 3: {
                LeggingsSettings settings = (LeggingsSettings)this.theSettings;
                return settings.getDuraRGBValues(this.cat);
            }
            case 4: {
                BootsSettings settings = (BootsSettings)this.theSettings;
                return settings.getDuraRGBValues(this.cat);
            }
            case 5: {
                HeldItemSettings settings = (HeldItemSettings)this.theSettings;
                return settings.getDuraRGBValues(this.cat);
            }
        }
        return null;
    }

    public void func_146281_b() {
        this.mod.getSm().saveSettings();
    }

    public boolean func_73868_f() {
        return false;
    }
}

