/*
 * Decompiled with CFR 0.152.
 */
package me.powns.armorhud.settings.modules;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import me.powns.armorhud.settings.SettingsManager;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HelmetSettings {
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int addX = 0;
    private int addY = 0;
    private int duraColorR1 = 0;
    private int duraColorG1 = 160;
    private int duraColorB1 = 0;
    private int color1;
    private int duraColorR2 = 220;
    private int duraColorG2 = 210;
    private int duraColorB2 = 0;
    private int color2;
    private int duraColorR3 = 190;
    private int duraColorG3 = 120;
    private int duraColorB3 = 0;
    private int color3;
    private int duraColorR4 = 160;
    private int duraColorG4 = 0;
    private int duraColorB4 = 0;
    private int color4;
    private boolean chroma;
    private boolean shown;
    private SettingsManager manager;

    public HelmetSettings(SettingsManager manager) {
        float[] theColor = Color.RGBtoHSB(this.duraColorR1, this.duraColorG1, this.duraColorB1, null);
        this.color1 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR2, this.duraColorG2, this.duraColorB2, null);
        this.color2 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR3, this.duraColorG3, this.duraColorB3, null);
        this.color3 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR4, this.duraColorG4, this.duraColorB4, null);
        this.color4 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        this.chroma = false;
        this.shown = true;
        this.manager = manager;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent e) {
        int minX = this.addX;
        int minY = this.addY;
        int maxX = this.addX + 30;
        int maxY = this.addY + 15;
        float[] theColor = Color.RGBtoHSB(this.duraColorR1, this.duraColorG1, this.duraColorB1, null);
        this.color1 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR2, this.duraColorG2, this.duraColorB2, null);
        this.color2 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR3, this.duraColorG3, this.duraColorB3, null);
        this.color3 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        theColor = Color.RGBtoHSB(this.duraColorR4, this.duraColorG4, this.duraColorB4, null);
        this.color4 = Color.HSBtoRGB(theColor[0], theColor[1], theColor[2]);
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void setDuraColor(int colorCat, int r, int g, int b) {
        switch (colorCat) {
            case 1: {
                this.duraColorR1 = r;
                this.duraColorG1 = g;
                this.duraColorB1 = b;
                break;
            }
            case 2: {
                this.duraColorR2 = r;
                this.duraColorG2 = g;
                this.duraColorB2 = b;
                break;
            }
            case 3: {
                this.duraColorR3 = r;
                this.duraColorG3 = g;
                this.duraColorB3 = b;
                break;
            }
            case 4: {
                this.duraColorR4 = r;
                this.duraColorG4 = g;
                this.duraColorB4 = b;
                break;
            }
        }
    }

    public ArrayList<Integer> getDuraRGBValues(int colorCat) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        switch (colorCat) {
            case 1: {
                result.add(this.duraColorR1);
                result.add(this.duraColorG1);
                result.add(this.duraColorB1);
                break;
            }
            case 2: {
                result.add(this.duraColorR2);
                result.add(this.duraColorG2);
                result.add(this.duraColorB2);
                break;
            }
            case 3: {
                result.add(this.duraColorR3);
                result.add(this.duraColorG3);
                result.add(this.duraColorB3);
                break;
            }
            case 4: {
                result.add(this.duraColorR4);
                result.add(this.duraColorG4);
                result.add(this.duraColorB4);
                break;
            }
        }
        return result;
    }

    public int getDuraColor(int colorCat) {
        if (this.chroma) {
            return Color.HSBtoRGB((float)(System.currentTimeMillis() % 1000L) / 1000.0f, 0.8f, 0.8f);
        }
        switch (colorCat) {
            case 1: {
                return this.color1;
            }
            case 2: {
                return this.color2;
            }
            case 3: {
                return this.color3;
            }
            case 4: {
                return this.color4;
            }
        }
        return -1;
    }

    public void saveConfig() {
        try {
            File file = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "Powns' ArmorStatus HUD", "helmet.cfg");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            FileWriter writer = new FileWriter(file, false);
            writer.write("Enabled?:\n" + this.shown + "\n \nPositioning:\n" + this.addX + "\n" + this.addY + "\n \nChroma?:\n" + this.chroma + "\n \nColor1:\n" + this.duraColorR1 + "\n" + this.duraColorG1 + "\n" + this.duraColorB1 + "\n \nColor2:\n" + this.duraColorR2 + "\n" + this.duraColorG2 + "\n" + this.duraColorB2 + "\n \nColor3:\n" + this.duraColorR3 + "\n" + this.duraColorG3 + "\n" + this.duraColorB3 + "\n \nColor4:\n" + this.duraColorR4 + "\n" + this.duraColorG4 + "\n" + this.duraColorB4 + "\n \n");
            writer.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void syncSettings() {
        this.manager.getChestplateSettings().setChroma(this.chroma);
        this.manager.getLeggingsSettings().setChroma(this.chroma);
        this.manager.getBootsSettings().setChroma(this.chroma);
        this.manager.getHelditemSettings().setChroma(this.chroma);
        this.manager.getChestplateSettings().setDuraColor(1, this.duraColorR1, this.duraColorG1, this.duraColorB1);
        this.manager.getChestplateSettings().setDuraColor(2, this.duraColorR2, this.duraColorG2, this.duraColorB2);
        this.manager.getChestplateSettings().setDuraColor(3, this.duraColorR3, this.duraColorG3, this.duraColorB3);
        this.manager.getChestplateSettings().setDuraColor(4, this.duraColorR4, this.duraColorG4, this.duraColorB4);
        this.manager.getLeggingsSettings().setDuraColor(1, this.duraColorR1, this.duraColorG1, this.duraColorB1);
        this.manager.getLeggingsSettings().setDuraColor(2, this.duraColorR2, this.duraColorG2, this.duraColorB2);
        this.manager.getLeggingsSettings().setDuraColor(3, this.duraColorR3, this.duraColorG3, this.duraColorB3);
        this.manager.getLeggingsSettings().setDuraColor(4, this.duraColorR4, this.duraColorG4, this.duraColorB4);
        this.manager.getBootsSettings().setDuraColor(1, this.duraColorR1, this.duraColorG1, this.duraColorB1);
        this.manager.getBootsSettings().setDuraColor(2, this.duraColorR2, this.duraColorG2, this.duraColorB2);
        this.manager.getBootsSettings().setDuraColor(3, this.duraColorR3, this.duraColorG3, this.duraColorB3);
        this.manager.getBootsSettings().setDuraColor(4, this.duraColorR4, this.duraColorG4, this.duraColorB4);
        this.manager.getHelditemSettings().setDuraColor(1, this.duraColorR1, this.duraColorG1, this.duraColorB1);
        this.manager.getHelditemSettings().setDuraColor(2, this.duraColorR2, this.duraColorG2, this.duraColorB2);
        this.manager.getHelditemSettings().setDuraColor(3, this.duraColorR3, this.duraColorG3, this.duraColorB3);
        this.manager.getHelditemSettings().setDuraColor(4, this.duraColorR4, this.duraColorG4, this.duraColorB4);
    }

    public void loadConfig() {
        try {
            String line;
            File file = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "Powns' ArmorStatus HUD", "helmet.cfg");
            if (!file.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int i = 0;
            block20: while ((line = reader.readLine()) != null) {
                switch (++i) {
                    case 2: {
                        this.shown = Boolean.parseBoolean(line);
                        continue block20;
                    }
                    case 5: {
                        this.addX = Integer.parseInt(line);
                        continue block20;
                    }
                    case 6: {
                        this.addY = Integer.parseInt(line);
                        continue block20;
                    }
                    case 9: {
                        this.chroma = Boolean.parseBoolean(line);
                        continue block20;
                    }
                    case 12: {
                        this.duraColorR1 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 13: {
                        this.duraColorG1 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 14: {
                        this.duraColorB1 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 17: {
                        this.duraColorR2 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 18: {
                        this.duraColorG2 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 19: {
                        this.duraColorB2 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 22: {
                        this.duraColorR3 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 23: {
                        this.duraColorG3 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 24: {
                        this.duraColorB3 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 27: {
                        this.duraColorR4 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 28: {
                        this.duraColorG4 = Integer.parseInt(line);
                        continue block20;
                    }
                    case 29: {
                        this.duraColorB4 = Integer.parseInt(line);
                        continue block20;
                    }
                }
            }
            reader.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getAddX() {
        return this.addX;
    }

    public void setAddX(int addX) {
        this.addX = addX;
    }

    public int getAddY() {
        return this.addY;
    }

    public void setAddY(int addY) {
        this.addY = addY;
    }

    public boolean isChroma() {
        return this.chroma;
    }

    public void setChroma(boolean chroma) {
        this.chroma = chroma;
    }

    public boolean isShown() {
        return this.shown;
    }

    public void setShown(boolean shown) {
        this.shown = shown;
    }
}

