/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.command;

import club.sk1er.mods.core.ModCore;
import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.screen.ScreenHistory;
import club.sk1er.patcher.util.benchmark.AbstractBenchmark;
import club.sk1er.patcher.util.benchmark.BenchmarkResult;
import club.sk1er.patcher.util.benchmark.impl.ItemBenchmark;
import club.sk1er.patcher.util.benchmark.impl.TextBenchmark;
import club.sk1er.patcher.util.chat.ChatUtilities;
import club.sk1er.patcher.util.enhancement.EnhancementManager;
import club.sk1er.patcher.util.enhancement.item.EnhancedItemRenderer;
import club.sk1er.patcher.util.enhancement.text.EnhancedFontRenderer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public class PatcherCommand
extends CommandBase {
    private final Map<String, AbstractBenchmark> benchmarkMap = new HashMap<String, AbstractBenchmark>();

    public PatcherCommand() {
        this.benchmarkMap.put("text", new TextBenchmark());
        this.benchmarkMap.put("item", new ItemBenchmark());
    }

    public String func_71517_b() {
        return "patcher";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [&amode <vanilla|optimized> &r| &bbenchmark <all, text, item> &r| &cdebugfps &r| &dsounds &r| &eresetcache &r| &2name [username] &r| &3blacklist <ip>&e]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length >= 2) {
            if (args[0].equalsIgnoreCase("mode")) {
                switch (args[1]) {
                    case "vanilla": {
                        this.toggleOptions(false);
                        Patcher.instance.getDebugPerformanceRenderer().setMode("Vanilla");
                        ChatUtilities.sendNotification("Debug Renderer", "&aSet mode: &cVanilla&a.");
                        return;
                    }
                    case "optimized": {
                        this.toggleOptions(true);
                        Patcher.instance.getDebugPerformanceRenderer().setMode("Optimized");
                        ChatUtilities.sendNotification("Debug Renderer", "&aSet mode: &eOptimized&a.");
                        return;
                    }
                }
                ChatUtilities.sendNotification("Debug Renderer", "&cUnknown mode. Vanilla & Optimized are the only modes available.");
                return;
            }
            if (args[0].equalsIgnoreCase("benchmark") || args[0].equalsIgnoreCase("bench")) {
                if (args[1].equals("all")) {
                    long totalMillis = 0L;
                    for (Map.Entry<String, AbstractBenchmark> benchmarkEntry : this.benchmarkMap.entrySet()) {
                        long millis = this.runBenchmark(benchmarkEntry.getKey(), new String[0], benchmarkEntry.getValue());
                        totalMillis += millis;
                    }
                    float seconds = (float)totalMillis / 1000.0f;
                    ChatUtilities.sendNotification("Performance Benchmark", "&3All of the benchmarks completed in " + seconds + "s.");
                    return;
                }
                AbstractBenchmark benchmark = this.benchmarkMap.get(args[1]);
                if (benchmark == null) {
                    ChatUtilities.sendNotification("Performance Benchmark", "&cCan't find a \"" + args[1] + "\" benchmark by the name of \"" + args[1] + "\".");
                    return;
                }
                this.runBenchmark(args[1], Arrays.copyOfRange(args, 2, args.length), benchmark);
                return;
            }
            if (args[0].equalsIgnoreCase("name") || args[0].equalsIgnoreCase("names")) {
                ModCore.getInstance().getGuiHandler().open((GuiScreen)new ScreenHistory(args[1], false));
                return;
            }
            if (args[0].equalsIgnoreCase("blacklist")) {
                String status = Patcher.instance.addOrRemoveBlacklist(args[1]) ? "&cnow" : "&ano longer";
                ChatUtilities.sendNotification("Server Blacklist", "Server &e\"" + args[1] + "\" &r is " + status + " &rblacklisted from chat length extension.");
                Patcher.instance.saveBlacklistedServers();
                return;
            }
            return;
        }
        if (args.length == 1) {
            switch (args[0]) {
                case "resetcache": {
                    EnhancementManager.getInstance().getEnhancement(EnhancedFontRenderer.class).invalidateAll();
                    EnhancementManager.getInstance().getEnhancement(EnhancedItemRenderer.class).invalidateAll();
                    ChatUtilities.sendNotification("Enhancement Cache", "&aCleared item & font enhancement cache.");
                    return;
                }
                case "debugfps": {
                    Patcher.instance.getDebugPerformanceRenderer().toggleFPS();
                    ChatUtilities.sendNotification("Debug Renderer", "&aToggled the debug renderer.");
                    return;
                }
                case "sounds": {
                    ModCore.getInstance().getGuiHandler().open((GuiScreen)Patcher.instance.getPatcherSoundConfig().gui());
                    return;
                }
                case "name": 
                case "names": {
                    ModCore.getInstance().getGuiHandler().open((GuiScreen)new ScreenHistory());
                    return;
                }
                case "blacklist": {
                    ChatUtilities.sendNotification("Server Blacklist", "&cPlease insert an IP to blacklist.");
                    return;
                }
                case "benchmark": {
                    ChatUtilities.sendNotification("Performance Benchmark", "&cPlease insert a test benchmark.\n&cAvailable options are: &eall, text, item&c.");
                    return;
                }
            }
            ChatUtilities.sendMessage("&cInvalid command. Usage: &e" + this.func_71518_a(sender) + "&c.");
            return;
        }
        ModCore.getInstance().getGuiHandler().open((GuiScreen)Patcher.instance.getPatcherConfig().gui());
    }

    private long runBenchmark(String benchmarkName, String[] args, AbstractBenchmark benchmark) {
        this.sendMessage("&3Beginning benchmark with the name " + benchmarkName + ".");
        benchmark.setup();
        benchmark.warmUp();
        BenchmarkResult[] results = benchmark.benchmark(args);
        benchmark.tearDown();
        long totalMillis = 0L;
        for (BenchmarkResult result : results) {
            this.sendMessage("&9&m--------------------------------------");
            this.sendMessage("&6" + result.getName());
            float millis = (float)result.getDeltaTime() / 1000000.0f;
            float nanosPerIteration = (float)result.getDeltaTime() / (float)result.getIterations();
            this.sendMessage("&6Benchmark took a total time of " + millis + "ms.");
            this.sendMessage("&6Each iteration took an average of " + nanosPerIteration + "ns.");
            this.sendMessage("&9&m--------------------------------------");
            totalMillis = (long)((float)totalMillis + millis);
        }
        this.sendMessage("&3Completed the " + benchmarkName + " benchmark.");
        return totalMillis;
    }

    private void sendMessage(String message) {
        ChatUtilities.sendMessage(message, false);
    }

    public int func_82362_a() {
        return -1;
    }

    private void toggleOptions(boolean status) {
        PatcherConfig.cullParticles = status;
        PatcherConfig.entityCulling = status;
        PatcherConfig.searchingOptimizationFix = status;
        PatcherConfig.fullbright = status;
        PatcherConfig.disableConstantFogColorChecking = status;
        PatcherConfig.lowAnimationTick = status;
        PatcherConfig.staticParticleColor = status;
        PatcherConfig.optimizedFontRenderer = status;
        PatcherConfig.cacheFontData = status;
        PatcherConfig.removeCloudTransparency = status;
        PatcherConfig.gpuCloudRenderer = status;
        PatcherConfig.glErrorChecking = status;
        PatcherConfig.optimizedItemRenderer = status;
        PatcherConfig.limitChunks = status;
        PatcherConfig.optimizedResourcePackDiscovery = status;
        Minecraft.func_71410_x().field_71438_f.func_72712_a();
    }
}

