/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.config;

import club.sk1er.patcher.Patcher;
import club.sk1er.vigilance.Vigilant;
import club.sk1er.vigilance.data.Property;
import club.sk1er.vigilance.data.PropertyData;
import club.sk1er.vigilance.data.PropertyType;
import java.lang.annotation.Annotation;
import java.util.function.Consumer;

public class ConfigUtil {
    public static PropertyData createAndRegisterConfig(PropertyType type, String category, String subCategory, String name, String description, Object defaultValue, int min, int max, Consumer<Object> onUpdate) {
        PropertyData config = ConfigUtil.createConfig(type, category, subCategory, name, description, defaultValue, min, max, onUpdate);
        ConfigUtil.register(config);
        return config;
    }

    public static PropertyData createConfig(PropertyType type, String category, String subCategory, String name, String description, Object defaultValue, int min, int max, Consumer<Object> onUpdate) {
        Property property = ConfigUtil.createProperty(type, category, subCategory, name, description, min, max);
        PropertyData data = PropertyData.Companion.withValue(property, defaultValue, (Vigilant)Patcher.instance.getPatcherSoundConfig());
        if (onUpdate != null) {
            data.setCallbackConsumer(onUpdate);
        }
        return data;
    }

    public static void register(PropertyData data) {
        Patcher.instance.getPatcherSoundConfig().registerProperty(data);
    }

    public static Property createProperty(final PropertyType type, final String category, final String subCategory, final String name, final String description, final int min, final int max) {
        return new Property(){

            public boolean hidden() {
                return false;
            }

            public Class<? extends Annotation> annotationType() {
                return Property.class;
            }

            public PropertyType type() {
                return type;
            }

            public String subcategory() {
                return subCategory;
            }

            public String[] options() {
                return new String[0];
            }

            public String name() {
                return name;
            }

            public int min() {
                return min;
            }

            public int max() {
                return max;
            }

            public String description() {
                return description;
            }

            public String category() {
                return category;
            }
        };
    }
}

