/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DebugPerformanceRenderer {
    private boolean frameRender = false;
    private long updated = 0L;
    private String mode = "???";
    private final DecimalFormat format = new DecimalFormat("#.00");
    private final List<Long> frames = new ArrayList<Long>();
    private final String[] renderStrings = new String[5];
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.frameRender) {
            this.frames.add(System.currentTimeMillis());
            this.frames.removeIf(time -> System.currentTimeMillis() - time > 60000L);
            if (System.currentTimeMillis() - this.updated > TimeUnit.SECONDS.toMillis(1L)) {
                this.updated = System.currentTimeMillis();
                this.renderStrings[0] = "Mode: " + this.mode;
                int[] intervals = new int[]{1, 10, 30, 60};
                int e = 0;
                for (int interval : intervals) {
                    int amt = 0;
                    for (long frame : this.frames) {
                        if (System.currentTimeMillis() - frame >= TimeUnit.SECONDS.toMillis(interval)) continue;
                        ++amt;
                    }
                    this.renderStrings[++e] = "Avg on " + interval + "s: " + this.format.format((float)amt / (float)interval);
                }
            }
            ScaledResolution scaledResolution = new ScaledResolution(this.mc);
            int y = 40;
            for (String render : this.renderStrings) {
                this.mc.field_71466_p.func_175065_a(render, (float)(scaledResolution.func_78326_a() - 5 - this.mc.field_71466_p.func_78256_a(render)), (float)y, new Color(1, 165, 82).getRGB(), true);
                y += 10;
            }
        }
    }

    public void toggleFPS() {
        this.frameRender = !this.frameRender;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

