/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ChunkTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.world.chunk.Chunk"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        List<String> brightness = Arrays.asList("getLightFor", "func_177413_a", "getLightSubtracted", "func_177443_a");
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (brightness.contains(methodName)) {
                methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.setLightLevel());
            }
            block8 : switch (methodName) {
                case "setBlockState": 
                case "func_177436_a": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        String methodInsnName;
                        if (!(next instanceof MethodInsnNode) || next.getOpcode() != 183 || !(methodInsnName = this.mapMethodNameFromNode(next)).equals("relightBlock") && !methodInsnName.equals("func_76615_h") || next.getPrevious().getPrevious().getOpcode() != 96) continue;
                        methodNode.instructions.remove(next.getPrevious().getPrevious());
                        methodNode.instructions.remove(next.getPrevious().getPrevious());
                        break block8;
                    }
                    break;
                }
                case "getBlockState": 
                case "func_177435_g": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.getBlockStateFast());
                    break;
                }
                case "setHeightMap": 
                case "func_177420_a": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.fixHeightmapMinimum());
                }
            }
        }
    }

    private InsnList fixHeightmapMinimum() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76634_f", "[I"));
        list.add((AbstractInsnNode)new InsnNode(190));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new InsnNode(190));
        LabelNode ificmpeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(159, ificmpeq));
        list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/world/chunk/Chunk", "field_150817_t", "Lorg/apache/logging/log4j/Logger;"));
        list.add((AbstractInsnNode)new TypeInsnNode(187, "java/lang/StringBuilder"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/StringBuilder", "<init>", "()V", false));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)"Could not set level chunk heightmap, array length is "));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new InsnNode(190));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)" instead of "));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76634_f", "[I"));
        list.add((AbstractInsnNode)new InsnNode(190));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "append", "(I)Ljava/lang/StringBuilder;", false));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "org/apache/logging/log4j/Logger", "warn", "(Ljava/lang/String;)V", true));
        LabelNode gotoInsn = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(167, gotoInsn));
        list.add((AbstractInsnNode)ificmpeq);
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new InsnNode(3));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76634_f", "[I"));
        list.add((AbstractInsnNode)new InsnNode(3));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76634_f", "[I"));
        list.add((AbstractInsnNode)new InsnNode(190));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76634_f", "[I"));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "com/google/common/primitives/Ints", "min", "([I)I", false));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/world/chunk/Chunk", "field_82912_p", "I"));
        list.add((AbstractInsnNode)gotoInsn);
        list.add((AbstractInsnNode)new InsnNode(177));
        return list;
    }

    private InsnList getBlockStateFast() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/BlockPos", "func_177958_n", "()I", false));
        list.add((AbstractInsnNode)new VarInsnNode(54, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/BlockPos", "func_177956_o", "()I", false));
        list.add((AbstractInsnNode)new VarInsnNode(54, 3));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/BlockPos", "func_177952_p", "()I", false));
        list.add((AbstractInsnNode)new VarInsnNode(54, 4));
        list.add((AbstractInsnNode)new VarInsnNode(21, 3));
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(155, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(21, 3));
        list.add((AbstractInsnNode)new InsnNode(7));
        list.add((AbstractInsnNode)new InsnNode(122));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76652_q", "[Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;"));
        list.add((AbstractInsnNode)new InsnNode(190));
        list.add((AbstractInsnNode)new JumpInsnNode(162, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", "field_76652_q", "[Lnet/minecraft/world/chunk/storage/ExtendedBlockStorage;"));
        list.add((AbstractInsnNode)new VarInsnNode(21, 3));
        list.add((AbstractInsnNode)new InsnNode(7));
        list.add((AbstractInsnNode)new InsnNode(122));
        list.add((AbstractInsnNode)new InsnNode(50));
        list.add((AbstractInsnNode)new VarInsnNode(58, 5));
        list.add((AbstractInsnNode)new VarInsnNode(25, 5));
        list.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(21, 2));
        list.add((AbstractInsnNode)new IntInsnNode(16, 15));
        list.add((AbstractInsnNode)new InsnNode(126));
        list.add((AbstractInsnNode)new VarInsnNode(54, 6));
        list.add((AbstractInsnNode)new VarInsnNode(21, 3));
        list.add((AbstractInsnNode)new IntInsnNode(16, 15));
        list.add((AbstractInsnNode)new InsnNode(126));
        list.add((AbstractInsnNode)new VarInsnNode(54, 7));
        list.add((AbstractInsnNode)new VarInsnNode(21, 4));
        list.add((AbstractInsnNode)new IntInsnNode(16, 15));
        list.add((AbstractInsnNode)new InsnNode(126));
        list.add((AbstractInsnNode)new VarInsnNode(54, 8));
        list.add((AbstractInsnNode)new VarInsnNode(25, 5));
        list.add((AbstractInsnNode)new VarInsnNode(21, 6));
        list.add((AbstractInsnNode)new VarInsnNode(21, 7));
        list.add((AbstractInsnNode)new VarInsnNode(21, 8));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/chunk/storage/ExtendedBlockStorage", "func_177485_a", "(III)Lnet/minecraft/block/state/IBlockState;", false));
        list.add((AbstractInsnNode)new InsnNode(176));
        list.add((AbstractInsnNode)labelNode);
        list.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/init/Blocks", "field_150350_a", "Lnet/minecraft/block/Block;"));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/block/Block", "func_176223_P", "()Lnet/minecraft/block/state/IBlockState;", false));
        list.add((AbstractInsnNode)new InsnNode(176));
        return list;
    }

    private InsnList setLightLevel() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/patcher/util/world/FullbrightTicker", "isFullbright", "()Z", false));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new IntInsnNode(16, 15));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }
}

