/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EffectRendererTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.particle.EffectRenderer"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName;
            block12 : switch (methodName = this.mapMethodName(classNode, methodNode)) {
                case "renderParticles": 
                case "func_78874_a": {
                    ListIterator iterator = methodNode.instructions.iterator();
                    LabelNode ifeq = new LabelNode();
                    int entityfxIndex = -1;
                    for (LocalVariableNode variable : methodNode.localVariables) {
                        if (!variable.name.equals("entityfx") && !variable.name.equals("var13")) continue;
                        entityfxIndex = variable.index;
                        break;
                    }
                    while (iterator.hasNext()) {
                        AbstractInsnNode next = (AbstractInsnNode)iterator.next();
                        if (next instanceof MethodInsnNode && ((MethodInsnNode)next).name.equals("get")) {
                            next = next.getNext().getNext();
                            methodNode.instructions.insertBefore(next.getNext(), this.determineRender(entityfxIndex, ifeq));
                            continue;
                        }
                        if (!(next instanceof InsnNode) || next.getOpcode() != 191) continue;
                        methodNode.instructions.insertBefore(next.getNext(), (AbstractInsnNode)ifeq);
                    }
                    break;
                }
                case "updateEffectAlphaLayer": 
                case "func_178925_a": {
                    ListIterator iterator = methodNode.instructions.iterator();
                    int entityfxIndex = -1;
                    for (LocalVariableNode var : methodNode.localVariables) {
                        if (!var.name.equals("entityfx") && !var.name.equals("var4")) continue;
                        entityfxIndex = var.index;
                        break;
                    }
                    while (iterator.hasNext()) {
                        String methodInsnName;
                        AbstractInsnNode next = (AbstractInsnNode)iterator.next();
                        if (!(next instanceof MethodInsnNode) || next.getOpcode() != 183 || !(methodInsnName = this.mapMethodNameFromNode(next)).equals("tickParticle") && !methodInsnName.equals("func_178923_d")) continue;
                        methodNode.instructions.insertBefore(next.getNext(), this.checkIfCull(entityfxIndex));
                        break block12;
                    }
                    break;
                }
                case "func_78872_b": 
                case "renderLitParticles": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        if (!(next instanceof VarInsnNode) || next.getOpcode() != 56 || ((VarInsnNode)next).var != 8) continue;
                        while (next.getPrevious() != null) {
                            methodNode.instructions.remove(next.getPrevious());
                        }
                        methodNode.instructions.insertBefore(next.getNext(), this.reassignRotation());
                        methodNode.instructions.remove(next);
                        break block12;
                    }
                    break;
                }
                case "func_180533_a": 
                case "addBlockDestroyEffects": 
                case "func_180532_a": 
                case "addBlockHitEffects": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.cancelParticles());
                }
            }
        }
    }

    private InsnList reassignRotation() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf((float)Math.PI / 180)));
        list.add((AbstractInsnNode)new VarInsnNode(56, 3));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/ActiveRenderInfo", "func_178808_b", "()F", false));
        list.add((AbstractInsnNode)new VarInsnNode(56, 4));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/ActiveRenderInfo", "func_178803_d", "()F", false));
        list.add((AbstractInsnNode)new VarInsnNode(56, 5));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/ActiveRenderInfo", "func_178805_e", "()F", false));
        list.add((AbstractInsnNode)new VarInsnNode(56, 6));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/ActiveRenderInfo", "func_178807_f", "()F", false));
        list.add((AbstractInsnNode)new VarInsnNode(56, 7));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/ActiveRenderInfo", "func_178809_c", "()F", false));
        list.add((AbstractInsnNode)new VarInsnNode(56, 8));
        return list;
    }

    private InsnList cancelParticles() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "disableBlockBreakParticles", "Z"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }

    private InsnList checkIfCull(int entityfxIndex) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, "club/sk1er/patcher/util/world/particles/ParticleCulling", "camera", "Lnet/minecraft/client/renderer/culling/ICamera;"));
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(198, labelNode));
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "cullParticles", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(25, entityfxIndex));
        list.add((AbstractInsnNode)new FieldInsnNode(178, "club/sk1er/patcher/util/world/particles/ParticleCulling", "camera", "Lnet/minecraft/client/renderer/culling/ICamera;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, entityfxIndex));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/client/particle/EntityFX", "func_174813_aQ", "()Lnet/minecraft/util/AxisAlignedBB;", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "net/minecraft/client/renderer/culling/ICamera", "func_78546_a", "(Lnet/minecraft/util/AxisAlignedBB;)Z", true));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new InsnNode(12));
        LabelNode gotoInsn = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(167, gotoInsn));
        list.add((AbstractInsnNode)ifeq);
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(-1.0f)));
        list.add((AbstractInsnNode)gotoInsn);
        list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/client/particle/EntityFX", "field_70140_Q", "F"));
        list.add((AbstractInsnNode)labelNode);
        return list;
    }

    private InsnList determineRender(int entityfxIndex, LabelNode ifeq) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, entityfxIndex));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/patcher/util/world/particles/ParticleCulling", "shouldRender", "(Lnet/minecraft/client/particle/EntityFX;)Z", false));
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        return list;
    }
}

