/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ItemStackTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.item.ItemStack"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (!methodName.equals("getTooltip") && !methodName.equals("func_82840_a")) continue;
            for (AbstractInsnNode node : methodNode.instructions) {
                if (node.getOpcode() != 18 || !((LdcInsnNode)node).cst.equals("Color: #")) continue;
                AbstractInsnNode next = node.getNext().getNext().getNext().getNext().getNext();
                methodNode.instructions.insert(next, this.fixHexColorPrintingEnd());
                methodNode.instructions.remove(next);
                methodNode.instructions.insert(node.getNext(), this.fixHexColorPrintingBeginning());
                return;
            }
        }
    }

    private InsnList fixHexColorPrintingBeginning() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new LdcInsnNode((Object)"%06X"));
        list.add((AbstractInsnNode)new InsnNode(4));
        list.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new InsnNode(3));
        return list;
    }

    private InsnList fixHexColorPrintingEnd() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false));
        list.add((AbstractInsnNode)new InsnNode(83));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/String", "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false));
        return list;
    }
}

