/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LayerArrowTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.entity.layers.LayerArrow"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (!methodName.equals("doRenderLayer") && !methodName.equals("func_177141_a")) continue;
            for (AbstractInsnNode next : methodNode.instructions) {
                if (!(next instanceof MethodInsnNode) || next.getOpcode() != 184) continue;
                String methodInsnName = this.mapMethodNameFromNode(next);
                if (methodInsnName.equals("disableStandardItemLighting") || methodInsnName.equals("func_74518_a")) {
                    methodNode.instructions.insertBefore(next, this.fixArrowLighting(true));
                    methodNode.instructions.remove(next);
                    continue;
                }
                if (!methodInsnName.equals("enableStandardItemLighting") && !methodInsnName.equals("func_74519_b")) continue;
                methodNode.instructions.insertBefore(next, this.fixArrowLighting(false));
                methodNode.instructions.remove(next);
                break;
            }
            methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.cancelRendering());
            break;
        }
    }

    private InsnList fixArrowLighting(boolean status) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "fixArrowLighting", "Z"));
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(154, labelNode));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/RenderHelper", status ? "func_74518_a" : "func_74519_b", "()V", false));
        list.add((AbstractInsnNode)labelNode);
        return list;
    }

    private InsnList cancelRendering() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "disableAttachedArrows", "Z"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)ifeq);
        return list;
    }
}

