/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ServerListTransformer
implements PatcherTransformer {
    private final String hookClass = this.getHooksPackage("ServerListHook");

    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.multiplayer.ServerList"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName;
            switch (methodName = this.mapMethodName(classNode, methodNode)) {
                case "getServerData": 
                case "func_78850_a": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.getCleanServerData());
                    break;
                }
                case "removeServerData": 
                case "func_78851_b": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.removeCleanServerData());
                    break;
                }
                case "addServerData": 
                case "func_78849_a": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.addCleanServerData());
                    break;
                }
                case "swapServers": 
                case "func_78857_a": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.swapCleanServers());
                    break;
                }
                case "func_147413_a": {
                    this.clearInstructions(methodNode);
                    methodNode.instructions.insert(this.setClean());
                }
            }
        }
    }

    private InsnList setClean() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "set", "(Lnet/minecraft/client/multiplayer/ServerList;ILnet/minecraft/client/multiplayer/ServerData;)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        return list;
    }

    private InsnList swapCleanServers() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new VarInsnNode(21, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "swapServers", "(Lnet/minecraft/client/multiplayer/ServerList;II)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        return list;
    }

    private InsnList addCleanServerData() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "addServerData", "(Lnet/minecraft/client/multiplayer/ServerList;Lnet/minecraft/client/multiplayer/ServerData;)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        return list;
    }

    private InsnList removeCleanServerData() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "removeServerData", "(Lnet/minecraft/client/multiplayer/ServerList;I)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        return list;
    }

    private InsnList getCleanServerData() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "getServerData", "(Lnet/minecraft/client/multiplayer/ServerList;I)Lnet/minecraft/client/multiplayer/ServerData;", false));
        list.add((AbstractInsnNode)new InsnNode(176));
        return list;
    }
}

