/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SoundManagerTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.audio.SoundManager"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        FieldNode pausedSounds = new FieldNode(18, "pausedSounds", "Ljava/util/List;", null, null);
        classNode.fields.add(pausedSounds);
        for (MethodNode methodNode : classNode.methods) {
            String methodName;
            block9 : switch (methodName = this.mapMethodName(classNode, methodNode)) {
                case "playSound": 
                case "func_148611_c": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        if (!(next instanceof LdcInsnNode) || !((LdcInsnNode)next).cst.equals("Unable to play unknown soundEvent: {}")) continue;
                        next = next.getPrevious().getPrevious();
                        for (int i = 0; i < 10; ++i) {
                            methodNode.instructions.remove(next.getNext());
                        }
                        methodNode.instructions.remove(next);
                        break block9;
                    }
                    break;
                }
                case "func_148610_e": 
                case "pauseAllSounds": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        if (!(next instanceof MethodInsnNode) || next.getOpcode() != 182 || !((MethodInsnNode)next).name.equals("pause")) continue;
                        methodNode.instructions.insert(next, this.addToPausedSounds());
                        break block9;
                    }
                    break;
                }
                case "func_148604_f": 
                case "resumeAllSounds": {
                    for (AbstractInsnNode next : methodNode.instructions) {
                        String fieldInsnName;
                        if (!(next instanceof FieldInsnNode) || next.getOpcode() != 180 || !(fieldInsnName = this.mapFieldNameFromNode(next)).equals("playingSounds") && !fieldInsnName.equals("field_148629_h")) continue;
                        methodNode.instructions.remove(next.getNext());
                        methodNode.instructions.remove(next.getNext());
                        methodNode.instructions.insertBefore(next, this.iteratePausedSounds());
                        methodNode.instructions.remove(next);
                        break;
                    }
                    methodNode.instructions.insertBefore(methodNode.instructions.getLast().getPrevious(), this.clearPausedSounds());
                    break;
                }
                case "<init>": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getLast().getPrevious(), this.createPausedSounds());
                }
            }
        }
    }

    private InsnList iteratePausedSounds() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/audio/SoundManager", "pausedSounds", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "iterator", "()Ljava/util/Iterator;", true));
        return list;
    }

    private InsnList clearPausedSounds() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/audio/SoundManager", "pausedSounds", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "clear", "()V", true));
        return list;
    }

    private InsnList addToPausedSounds() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/audio/SoundManager", "pausedSounds", "Ljava/util/List;"));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true));
        list.add((AbstractInsnNode)new InsnNode(87));
        return list;
    }

    private InsnList createPausedSounds() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new TypeInsnNode(187, "java/util/ArrayList"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "java/util/ArrayList", "<init>", "()V", false));
        list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraft/client/audio/SoundManager", "pausedSounds", "Ljava/util/List;"));
        return list;
    }
}

