/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WorldServerTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.world.WorldServer"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            String methodName = this.mapMethodName(classNode, method);
            if (!methodName.equals("tick") && !methodName.equals("func_72835_b")) continue;
            ListIterator iterator = method.instructions.iterator();
            LabelNode ifne = new LabelNode();
            while (iterator.hasNext()) {
                AbstractInsnNode next = (AbstractInsnNode)iterator.next();
                if (!(next instanceof LdcInsnNode)) continue;
                if (((LdcInsnNode)next).cst.equals("doMobSpawning")) {
                    method.instructions.insertBefore(next.getPrevious().getPrevious(), this.disableMobspawnChecks(ifne));
                    continue;
                }
                if (!((LdcInsnNode)next).cst.equals("chunkSource")) continue;
                method.instructions.insertBefore(next.getPrevious().getPrevious(), this.setLabel(ifne));
            }
            break block0;
        }
    }

    private InsnList setLabel(LabelNode ifne) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)ifne);
        return list;
    }

    private InsnList disableMobspawnChecks(LabelNode ifne) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "mobSpawningOptimization", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(154, ifne));
        return list;
    }
}

