/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm.forge;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClientCommandHandlerTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraftforge.client.ClientCommandHandler"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName = this.mapMethodName(classNode, methodNode);
            if (!methodName.equals("executeCommand") && !methodName.equals("func_71556_a")) continue;
            for (AbstractInsnNode node : methodNode.instructions) {
                if (!(node instanceof InsnNode) || node.getOpcode() != 50) continue;
                methodNode.instructions.insertBefore(node.getNext(), ClientCommandHandlerTransformer.makeLowercase());
                break;
            }
            methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.checkForSlash());
            break;
        }
    }

    public static InsnList makeLowercase() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "toLowerCase", "()Ljava/lang/String;", false));
        return list;
    }

    private InsnList checkForSlash() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getPatcherConfigClass(), "forgeCommandHandling", "Z"));
        LabelNode ifeq = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, ifeq));
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "trim", "()Ljava/lang/String;", false));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)"/"));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/String", "startsWith", "(Ljava/lang/String;)Z", false));
        LabelNode ifne = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(154, ifne));
        list.add((AbstractInsnNode)new InsnNode(3));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)ifeq);
        list.add((AbstractInsnNode)ifne);
        return list;
    }
}

