/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.asm.lwjgl;

import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WindowsKeycodesTransformer
implements PatcherTransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"org.lwjgl.opengl.WindowsKeycodes"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            if (!methodNode.name.equals("mapVirtualKeyToLWJGLCode") || !methodNode.desc.equals("(I)I")) continue;
            methodNode.instructions.insert(methodNode.instructions.getFirst().getNext(), this.correctCodes());
            break;
        }
    }

    private InsnList correctCodes() {
        InsnList list = new InsnList();
        LabelNode labelNode = new LabelNode();
        list.add((AbstractInsnNode)new VarInsnNode(21, 0));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/patcher/util/KeycodeHelper", "extraVirtualKeysWindows", "(I)I", false));
        list.add((AbstractInsnNode)new VarInsnNode(54, 1));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new VarInsnNode(21, 0));
        list.add((AbstractInsnNode)new JumpInsnNode(159, labelNode));
        list.add((AbstractInsnNode)new VarInsnNode(21, 1));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)labelNode);
        return list;
    }
}

