/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.tweaker.other;

import club.sk1er.patcher.tweaker.ClassTransformer;
import club.sk1er.patcher.tweaker.asm.InventoryEffectRendererTransformer;
import club.sk1er.patcher.tweaker.asm.levelhead.LevelheadAboveHeadRenderTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.EntityCullingTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.EntityRendererTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.FontRendererHookTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.FullbrightTickerTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.GuiDetailSettingsOFTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.OptifineFontRendererTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.RandomEntitiesTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.RenderItemFrameTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.RenderTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.RendererLivingEntityTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.common.BakedQuadReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.common.EntityRendererReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.common.ExtendedBlockStorageReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.common.FaceBakeryReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.common.ModelRotationReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.reflectionoptimizations.modern.ItemModelMesherReflectionOptimizer;
import club.sk1er.patcher.tweaker.asm.optifine.signfix.GuiEditSignTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.signfix.TileEntitySignRendererTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.witherfix.EntityWitherTransformer;
import club.sk1er.patcher.tweaker.asm.optifine.xpfix.GuiIngameForgeTransformer;
import club.sk1er.patcher.tweaker.asm.pingtag.TagRendererListenerTransformer;
import club.sk1er.patcher.tweaker.asm.pingtag.TagRendererTransformer;
import club.sk1er.patcher.tweaker.asm.rporganizer.GuiCustomResourcePacks;
import club.sk1er.patcher.tweaker.asm.tnttime.TNTTimeTransformer;
import club.sk1er.patcher.tweaker.asm.ve.BetterChatTransformer;
import club.sk1er.patcher.tweaker.transform.PatcherTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModClassTransformer
implements IClassTransformer {
    private final Logger logger = LogManager.getLogger((String)"Patcher - Mod Class Transformer");
    private final Multimap<String, PatcherTransformer> transformerMap = ArrayListMultimap.create();

    public ModClassTransformer() {
        String optifineVersion;
        this.registerTransformer(new EntityRendererTransformer());
        this.registerTransformer(new RenderTransformer());
        this.registerTransformer(new RendererLivingEntityTransformer());
        this.registerTransformer(new RenderItemFrameTransformer());
        this.registerTransformer(new TagRendererTransformer());
        this.registerTransformer(new TagRendererListenerTransformer());
        this.registerTransformer(new LevelheadAboveHeadRenderTransformer());
        this.registerTransformer(new TNTTimeTransformer());
        this.registerTransformer(new GuiCustomResourcePacks());
        this.registerTransformer(new BetterChatTransformer());
        if (!ModClassTransformer.isDevelopment()) {
            this.registerTransformer(new InventoryEffectRendererTransformer());
        }
        if ((optifineVersion = ClassTransformer.optifineVersion).equals("I7")) {
            this.logger.info("Found OptiFine I7");
            this.registerCommonTransformers();
            this.registerI7Transformers();
        } else if (optifineVersion.startsWith("L6") || optifineVersion.equals("L5")) {
            this.logger.info("Found OptiFine " + optifineVersion);
            this.registerCommonTransformers();
            this.registerLSeriesTransformers();
            this.registerLSeriesFixesTransformers();
        } else if (optifineVersion.startsWith("M5")) {
            this.logger.info("Found OptiFine M5");
            this.registerCommonTransformers();
            this.registerLSeriesTransformers();
        } else {
            this.logger.info("User has either an old OptiFine version, or no OptiFine present. Aborting reflection optimizations.");
        }
    }

    private void registerTransformer(PatcherTransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        return ClassTransformer.createTransformer(transformedName, bytes, this.transformerMap, this.logger);
    }

    private void registerCommonTransformers() {
        this.registerTransformer(new BakedQuadReflectionOptimizer());
        this.registerTransformer(new FaceBakeryReflectionOptimizer());
        this.registerTransformer(new ModelRotationReflectionOptimizer());
        this.registerTransformer(new ExtendedBlockStorageReflectionOptimizer());
        this.registerTransformer(new EntityRendererReflectionOptimizer());
        this.registerTransformer(new GuiIngameForgeTransformer());
        this.registerTransformer(new OptifineFontRendererTransformer());
        this.registerTransformer(new FontRendererHookTransformer());
        this.registerTransformer(new FullbrightTickerTransformer());
        this.registerTransformer(new EntityCullingTransformer());
    }

    private void registerI7Transformers() {
    }

    private void registerLSeriesTransformers() {
        this.registerTransformer(new ItemModelMesherReflectionOptimizer());
        this.registerTransformer(new GuiDetailSettingsOFTransformer());
    }

    private void registerLSeriesFixesTransformers() {
        this.registerTransformer(new GuiEditSignTransformer());
        this.registerTransformer(new TileEntitySignRendererTransformer());
        this.registerTransformer(new RandomEntitiesTransformer());
        this.registerTransformer(new EntityWitherTransformer());
    }

    public static boolean isDevelopment() {
        Object o = Launch.blackboard.get("fml.deobfuscatedEnvironment");
        return o != null && (Boolean)o != false;
    }
}

