/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.benchmark.impl;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.benchmark.AbstractBenchmark;
import club.sk1er.patcher.util.benchmark.BenchmarkResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;

public class ItemBenchmark
extends AbstractBenchmark {
    private static final int renderItemIters = 100000;

    @Override
    public BenchmarkResult[] benchmark(String[] args) {
        ItemCameraTransforms.TransformType[] types = ItemCameraTransforms.TransformType.values();
        BenchmarkResult[] results = new BenchmarkResult[types.length];
        for (int i = 0; i < types.length; ++i) {
            results[i] = this.renderItemBenchmark(types[i]);
        }
        return results;
    }

    private BenchmarkResult renderItemBenchmark(ItemCameraTransforms.TransformType type) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        ItemStack item = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        long begin = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            renderItem.func_181564_a(item, type);
        }
        long end = System.nanoTime();
        return new BenchmarkResult(end - begin, 100000L, "Rendering 100000 of the item you are holding. (TransformType: " + type.name() + ")." + this.getItemResult());
    }

    private String getItemResult() {
        return "\n&6Current Item Renderer: &3" + (PatcherConfig.optimizedItemRenderer ? "Optimized." : "Vanilla.");
    }
}

