/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.benchmark.impl;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.benchmark.AbstractBenchmark;
import club.sk1er.patcher.util.benchmark.BenchmarkResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class TextBenchmark
extends AbstractBenchmark {
    private static final int sepIters = 100000;
    private static final int genericIters = 10000;
    private String longString;
    private FontRenderer fontRenderer;

    @Override
    public void setup() {
        super.setup();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&o&");
        for (int i = 0; i < 100000; ++i) {
            stringBuilder.append("e");
        }
        this.longString = stringBuilder.toString();
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.longString = null;
        this.fontRenderer = null;
    }

    @Override
    public BenchmarkResult[] benchmark(String[] args) {
        if (args.length >= 1) {
            switch (args[0]) {
                case "list": {
                    this.sendMessage("&3Options are: &6separate, single, average, all.");
                    return new BenchmarkResult[0];
                }
                case "separate": {
                    return new BenchmarkResult[]{this.separateRendersBenchmark()};
                }
                case "single": {
                    return new BenchmarkResult[]{this.singleRenderBenchmark()};
                }
                case "average": {
                    return new BenchmarkResult[]{this.averageTextBenchmark()};
                }
                case "all": {
                    return new BenchmarkResult[]{this.separateRendersBenchmark(), this.singleRenderBenchmark(), this.averageTextBenchmark()};
                }
            }
            this.sendMessage("Can't find a text benchmark by the name of " + args[0]);
            return new BenchmarkResult[0];
        }
        return new BenchmarkResult[]{this.separateRendersBenchmark(), this.singleRenderBenchmark(), this.averageTextBenchmark()};
    }

    private BenchmarkResult averageTextBenchmark() {
        String average = "&c&mThis is my sentence that contains lots of standard characters";
        long begin = System.nanoTime();
        for (int i = 0; i < 10000; ++i) {
            this.fontRenderer.func_175063_a(average, 0.0f, 0.0f, -1);
        }
        long end = System.nanoTime();
        return new BenchmarkResult(end - begin, 10000L, "Rendering the string: \"" + average + "&r&6\" " + 10000 + " times." + this.getFontResult());
    }

    private BenchmarkResult singleRenderBenchmark() {
        long begin = System.nanoTime();
        this.fontRenderer.func_175063_a(this.longString, 0.0f, 0.0f, -1);
        long end = System.nanoTime();
        return new BenchmarkResult(end - begin, 1L, "Rendering " + (this.longString.length() - 4) + " letters, all at once." + this.getFontResult());
    }

    private BenchmarkResult separateRendersBenchmark() {
        long begin = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            this.fontRenderer.func_175063_a("&o&me", 0.0f, 0.0f, -1);
        }
        long end = System.nanoTime();
        return new BenchmarkResult(end - begin, 100000L, "Rendering 100000 letters, one after each other." + this.getFontResult());
    }

    private String getFontResult() {
        return "\n&6Current Font Renderer: &3" + (PatcherConfig.optimizedFontRenderer ? "Optimized." : "Vanilla.");
    }
}

