/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.chat;

import club.sk1er.mods.core.universal.ChatColor;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.chat.ChatComponentIgnored;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ChatHandler {
    private static final Map<Integer, ChatEntry> chatMessageMap = new HashMap<Integer, ChatEntry>();
    private static final Map<Integer, Set<ChatLine>> messagesForHash = new HashMap<Integer, Set<ChatLine>>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final String chatTimestampRegex = "^(?:\\[\\d\\d:\\d\\d(?: AM| PM|)]|<\\d\\d:\\d\\d>) ";
    public static int currentMessageHash = -1;
    private int ticks;

    @SubscribeEvent
    public void renderChat(RenderGameOverlayEvent.Chat event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CHAT && PatcherConfig.chatPosition) {
            event.posY -= 12;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onChatMessage(ClientChatReceivedEvent event) {
        if (PatcherConfig.timestamps && !event.message.func_150260_c().trim().isEmpty() && event.type != 2) {
            String timeFormat = LocalDateTime.now().format(DateTimeFormatter.ofPattern(PatcherConfig.timestampsFormat == 0 ? "[hh:mm a]" : "[HH:mm]"));
            ChatComponentIgnored time = new ChatComponentIgnored(ChatColor.GRAY + "[" + timeFormat + "] " + ChatColor.RESET);
            time.func_150257_a(event.message);
            event.message = time;
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (this.ticks++ >= 12000) {
            long time = System.currentTimeMillis();
            chatMessageMap.entrySet().removeIf(next -> {
                boolean oldEnough;
                boolean bl = oldEnough = time - ((ChatEntry)next.getValue()).lastSeenMessageMillis > (long)PatcherConfig.compactChatTime * 1000L;
                if (oldEnough) {
                    messagesForHash.remove(next.getKey());
                }
                return oldEnough;
            });
            this.ticks = 0;
        }
    }

    @SubscribeEvent
    public void changeWorld(WorldEvent.Load event) {
        this.ticks = 0;
    }

    public static boolean setChatLineHead(IChatComponent chatComponent, boolean refresh) {
        if (Loader.isModLoaded((String)"hychat") || Loader.isModLoaded((String)"labymod") || !PatcherConfig.compactChat) {
            return true;
        }
        if (!refresh) {
            String message = ChatHandler.cleanColour(chatComponent.func_150254_d()).trim();
            if (message.isEmpty() && PatcherConfig.antiClearChat) {
                return false;
            }
            if (message.isEmpty() || ChatHandler.isDivider(message)) {
                return true;
            }
            currentMessageHash = ChatHandler.getChatComponentHash(chatComponent);
            long currentTime = System.currentTimeMillis();
            if (!chatMessageMap.containsKey(currentMessageHash)) {
                chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
            } else {
                ChatEntry entry = chatMessageMap.get(currentMessageHash);
                if (currentTime - entry.lastSeenMessageMillis > (long)PatcherConfig.compactChatTime * 1000L) {
                    chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
                } else {
                    boolean deleted = ChatHandler.deleteMessageByHash(currentMessageHash);
                    if (!deleted) {
                        chatMessageMap.put(currentMessageHash, new ChatEntry(1, currentTime));
                    } else {
                        ++entry.messageCount;
                        entry.lastSeenMessageMillis = currentTime;
                        chatComponent.func_150257_a((IChatComponent)new ChatComponentIgnored(ChatColor.GRAY + " (" + entry.messageCount + ")"));
                    }
                }
            }
            return true;
        }
        return true;
    }

    public static void setChatLine_addToList(ChatLine line) {
        if (currentMessageHash != -1) {
            messagesForHash.computeIfAbsent(currentMessageHash, k -> new HashSet()).add(line);
        }
    }

    public static void setChatLineReturn() {
        currentMessageHash = -1;
    }

    private static boolean deleteMessageByHash(int hashCode) {
        ChatLine chatLine;
        int index;
        if (!messagesForHash.containsKey(hashCode) || messagesForHash.get(hashCode).isEmpty()) {
            return false;
        }
        Set<ChatLine> toRemove = messagesForHash.get(hashCode);
        messagesForHash.remove(hashCode);
        int normalSearchLength = 100;
        int wrappedSearchLength = 300;
        boolean removedMessage = false;
        List chatLines = ChatHandler.mc.field_71456_v.func_146158_b().field_146252_h;
        for (index = 0; index < chatLines.size() && index < 100; ++index) {
            chatLine = (ChatLine)chatLines.get(index);
            if (!toRemove.contains(chatLine)) continue;
            removedMessage = true;
            chatLines.remove(index);
            if (--index < 0 || index >= chatLines.size()) continue;
            index = ChatHandler.getMessageIndex(chatLines, index, chatLine);
        }
        if (!removedMessage) {
            return false;
        }
        List chatLinesWrapped = ChatHandler.mc.field_71456_v.func_146158_b().field_146253_i;
        for (index = 0; index < chatLinesWrapped.size() && index < 300; ++index) {
            chatLine = (ChatLine)chatLinesWrapped.get(index);
            if (!toRemove.contains(chatLine)) continue;
            chatLinesWrapped.remove(index);
            if (--index <= 0 || index >= chatLinesWrapped.size()) continue;
            index = ChatHandler.getMessageIndex(chatLinesWrapped, index, chatLine);
        }
        return true;
    }

    private static int getMessageIndex(List<ChatLine> chatMessageList, int index, ChatLine chatLine) {
        ChatLine prevLine = chatMessageList.get(index);
        if (ChatHandler.isDivider(ChatHandler.cleanColour(prevLine.func_151461_a().func_150260_c())) && Math.abs(chatLine.func_74540_b() - prevLine.func_74540_b()) <= 2) {
            chatMessageList.remove(index);
        }
        if (index >= chatMessageList.size()) {
            return index;
        }
        ChatLine nextLine = chatMessageList.get(index);
        if (ChatHandler.isDivider(ChatHandler.cleanColour(nextLine.func_151461_a().func_150260_c())) && Math.abs(chatLine.func_74540_b() - nextLine.func_74540_b()) <= 2) {
            chatMessageList.remove(index);
            --index;
        }
        return index;
    }

    private static int getChatStyleHash(ChatStyle style) {
        HoverEvent hoverEvent = style.func_150210_i();
        HoverEvent.Action hoverAction = null;
        int hoverChatHash = 0;
        if (hoverEvent != null) {
            hoverAction = hoverEvent.func_150701_a();
            hoverChatHash = ChatHandler.getChatComponentHash(hoverEvent.func_150702_b());
        }
        return Objects.hash(style.func_150215_a(), style.func_150223_b(), style.func_150242_c(), style.func_150234_e(), style.func_150236_d(), style.func_150233_f(), hoverAction, hoverChatHash, style.func_150235_h(), style.func_179986_j());
    }

    private static int getChatComponentHash(IChatComponent chatComponent) {
        ArrayList<Integer> siblingHashes = new ArrayList<Integer>();
        for (IChatComponent sibling : chatComponent.func_150253_a()) {
            if (sibling instanceof ChatComponentIgnored || !(sibling instanceof ChatComponentStyle)) continue;
            siblingHashes.add(ChatHandler.getChatComponentHash(sibling));
        }
        if (chatComponent instanceof ChatComponentIgnored) {
            return Objects.hash(siblingHashes);
        }
        String unformattedText = chatComponent.func_150260_c();
        String cleanedMessage = unformattedText.replaceAll(chatTimestampRegex, "").trim();
        return Objects.hash(cleanedMessage, siblingHashes, ChatHandler.getChatStyleHash(chatComponent.func_150256_b()));
    }

    private static boolean isDivider(String clean) {
        clean = clean.replaceAll(chatTimestampRegex, "").trim();
        boolean divider = true;
        if (clean.length() < 5) {
            divider = false;
        } else {
            for (int i = 0; i < clean.length(); ++i) {
                char c = clean.charAt(i);
                if (c == '-' || c == '=' || c == '\u25ac') continue;
                divider = false;
                break;
            }
        }
        return divider;
    }

    public static String cleanColour(String in) {
        return in.replaceAll("(?i)\\u00A7.", "");
    }

    static class ChatEntry {
        int messageCount;
        long lastSeenMessageMillis;

        ChatEntry(int messageCount, long lastSeenMessageMillis) {
            this.messageCount = messageCount;
            this.lastSeenMessageMillis = lastSeenMessageMillis;
        }
    }
}

