/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.enhancement.item;

import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.patcher.util.enhancement.Enhancement;
import club.sk1er.patcher.util.hash.impl.ItemHash;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.GLAllocation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnhancedItemRenderer
implements Enhancement {
    private static final List<EnhancedItemRenderer> instances = new ArrayList<EnhancedItemRenderer>();
    private final Queue<Integer> glRemoval = new ConcurrentLinkedQueue<Integer>();
    private final Cache<ItemHash, Integer> itemCache = Caffeine.newBuilder().maximumSize(5000L).writer((CacheWriter)new RemovalListener()).executor((Executor)Multithreading.POOL).build();

    @Override
    public String getName() {
        return "Enhanced Item Renderer";
    }

    public void invalidateAll() {
        this.itemCache.invalidateAll();
    }

    public int getGlList() {
        Integer poll = this.glRemoval.poll();
        return poll == null ? GLAllocation.func_74526_a((int)1) : poll;
    }

    public static List<EnhancedItemRenderer> getInstances() {
        return instances;
    }

    public Cache<ItemHash, Integer> getItemCache() {
        return this.itemCache;
    }

    private class RemovalListener
    implements CacheWriter<ItemHash, Integer> {
        private RemovalListener() {
        }

        public void write(@NonNull ItemHash key, @NonNull Integer value) {
        }

        public void delete(@NonNull ItemHash key, @Nullable Integer value, @NonNull RemovalCause cause) {
            if (value == null) {
                return;
            }
            EnhancedItemRenderer.this.glRemoval.add(value);
        }
    }
}

