/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.status;

import club.sk1er.mods.core.util.Multithreading;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Pair;
import net.minecraft.client.multiplayer.ServerAddress;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.status.INetHandlerStatusClient;
import net.minecraft.network.status.client.C00PacketServerQuery;
import net.minecraft.network.status.server.S00PacketServerInfo;
import net.minecraft.network.status.server.S01PacketPong;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class ProtocolDetector {
    public static final ProtocolDetector instance = new ProtocolDetector();
    private final Map<Pair<String, Integer>, CompletableFuture<Boolean>> futures = new ConcurrentHashMap<Pair<String, Integer>, CompletableFuture<Boolean>>();

    public CompletableFuture<Boolean> isCompatibleWithVersion(String ip, int version) {
        CompletableFuture<Boolean> cached = this.futures.get(new Pair((Object)ip, (Object)version));
        if (cached != null) {
            return cached;
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Pair tuple = new Pair((Object)ip, (Object)version);
        this.futures.put((Pair<String, Integer>)tuple, future);
        Multithreading.runAsync(() -> {
            try {
                ServerAddress address = ServerAddress.func_78860_a((String)ip);
                NetworkManager nm = NetworkManager.func_181124_a((InetAddress)InetAddress.getByName(address.func_78861_a()), (int)address.func_78864_b(), (boolean)false);
                nm.func_150719_a((INetHandler)new VersionCompatibilityStatusState(future, version, nm, () -> this.futures.remove(tuple)));
                nm.func_179290_a((Packet)new C00Handshake(version, address.func_78861_a(), address.func_78864_b(), EnumConnectionState.STATUS));
                nm.func_179290_a((Packet)new C00PacketServerQuery());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                this.futures.remove(tuple);
            }
        });
        return future;
    }

    private static class VersionCompatibilityStatusState
    implements INetHandlerStatusClient {
        private final CompletableFuture<Boolean> future;
        private final int version;
        private final NetworkManager manager;
        private final Runnable onComplete;
        private boolean received;

        public VersionCompatibilityStatusState(CompletableFuture<Boolean> future, int version, NetworkManager manager, Runnable onComplete) {
            this.future = future;
            this.version = version;
            this.manager = manager;
            this.onComplete = onComplete;
        }

        public void func_147397_a(S00PacketServerInfo packetIn) {
            if (this.received) {
                this.manager.func_150718_a((IChatComponent)new ChatComponentText("Done checking protocol versions."));
                return;
            }
            this.received = true;
            this.future.complete(packetIn.func_149294_c().func_151322_c().func_151304_b() >= this.version);
            this.onComplete.run();
        }

        public void func_147398_a(S01PacketPong packetIn) {
        }

        public void func_147231_a(IChatComponent reason) {
            if (this.future.isDone()) {
                return;
            }
            this.future.complete(false);
            this.onComplete.run();
        }
    }
}

