/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.iasfork.msauth;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.client.resources.I18n;
import org.lwjgl.Sys;
import ru.vidtu.iasfork.msauth.MSAuthHandler;
import ru.vidtu.iasfork.msauth.Request;
import the_fireplace.ias.tools.HttpTools;

public class AuthSys {
    private static final Gson gson = new Gson();
    private static volatile HttpServer srv;

    public static void start(final MSAuthHandler h) {
        final String done = "<html><body><h1>" + I18n.func_135052_a((String)"ias.msauth.canclosenow", (Object[])new Object[0]) + "</h1></body></html>";
        new Thread(() -> {
            try {
                if (srv != null) {
                    AuthSys.stop();
                    return;
                }
                h.setState("ias.msauth.state.waiting");
                if (!HttpTools.ping("http://minecraft.net")) {
                    throw new MicrosoftAuthException("No internet connection");
                }
                srv = HttpServer.create(new InetSocketAddress(59125), 0);
                srv.createContext("/", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange ex) throws IOException {
                        try {
                            h.cancellble(false);
                            h.setState("ias.msauth.state.response");
                            ex.getResponseHeaders().add("Location", "http://localhost:59125/end");
                            ex.sendResponseHeaders(302, -1L);
                            String s = ex.getRequestURI().getQuery();
                            if (s == null) {
                                h.error(new MicrosoftAuthException("query=null"));
                            } else if (s.startsWith("code=")) {
                                AuthSys.accessTokenStep(s.replace("code=", ""), h);
                            } else if (s.equals("error=access_denied&error_description=The user has denied access to the scope requested by the client application.")) {
                                h.error(new MicrosoftAuthException(I18n.func_135052_a((String)"ias.msauth.error.revoked", (Object[])new Object[0])));
                            } else {
                                h.error(new MicrosoftAuthException(s));
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            h.error(t);
                        }
                    }
                });
                srv.createContext("/end", new HttpHandler(){

                    @Override
                    public void handle(HttpExchange ex) throws IOException {
                        try {
                            byte[] b = done.getBytes(StandardCharsets.UTF_8);
                            ex.getResponseHeaders().put("Content-Type", Arrays.asList("text/html; charset=UTF-8"));
                            ex.sendResponseHeaders(200, b.length);
                            OutputStream os = ex.getResponseBody();
                            os.write(b);
                            os.flush();
                            os.close();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        AuthSys.stop();
                    }
                });
                srv.start();
                Sys.openURL((String)"https://login.live.com/oauth20_authorize.srf?client_id=54fd49e4-2103-4044-9603-2b028c814ec3&response_type=code&scope=XboxLive.signin%20XboxLive.offline_access&redirect_uri=http://localhost:59125&prompt=consent");
            }
            catch (Throwable t) {
                h.error(t);
                AuthSys.stop();
            }
        }, "Auth Thread").start();
    }

    public static void start(String access, String refresh, MSAuthHandler h) {
        h.cancellble(false);
        new Thread(() -> {
            try {
                AuthSys.minecraftStoreVerify(access, refresh, h);
            }
            catch (Throwable t) {
                try {
                    h.setState("ias.msauth.state.refreshing");
                    Request r = new Request("https://login.live.com/oauth20_token.srf").get();
                    HashMap<Object, Object> data = new HashMap<Object, Object>();
                    data.put("client_id", "54fd49e4-2103-4044-9603-2b028c814ec3");
                    data.put("refresh_token", refresh);
                    data.put("grant_type", "refresh_token");
                    data.put("redirect_uri", "http://localhost:59125");
                    r.post(data);
                    if (r.response() != 200) {
                        throw new MicrosoftAuthException("accessToken response: " + r.response());
                    }
                    JsonObject jo = (JsonObject)gson.fromJson(r.body(), JsonObject.class);
                    AuthSys.xblStep(jo.get("access_token").getAsString(), jo.get("refresh_token").getAsString(), h);
                }
                catch (Throwable th) {
                    h.error(t);
                }
            }
        }, "Auth Thread").start();
    }

    public static void stop() {
        try {
            if (srv != null) {
                srv.stop(0);
                srv = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void accessTokenStep(String code, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.token");
        Request pr = new Request("https://login.live.com/oauth20_token.srf").header("Content-Type", "application/x-www-form-urlencoded");
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put("client_id", "54fd49e4-2103-4044-9603-2b028c814ec3");
        data.put("code", code);
        data.put("grant_type", "authorization_code");
        data.put("redirect_uri", "http://localhost:59125");
        data.put("scope", "XboxLive.signin XboxLive.offline_access");
        pr.post(data);
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("accessToken response: " + pr.response());
        }
        JsonObject jo = (JsonObject)gson.fromJson(pr.body(), JsonObject.class);
        AuthSys.xblStep(jo.get("access_token").getAsString(), jo.get("refresh_token").getAsString(), h);
    }

    public static void xblStep(String token, String refresh, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.xbl");
        Request pr = new Request("https://user.auth.xboxlive.com/user/authenticate").header("Content-Type", "application/json").header("Accept", "application/json");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> sub = new HashMap<String, String>();
        sub.put("AuthMethod", "RPS");
        sub.put("SiteName", "user.auth.xboxlive.com");
        sub.put("RpsTicket", "d=" + token);
        map.put("Properties", sub);
        map.put("RelyingParty", "http://auth.xboxlive.com");
        map.put("TokenType", "JWT");
        pr.post(gson.toJson(map));
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("xbl response: " + pr.response());
        }
        AuthSys.xstsStep(((JsonObject)gson.fromJson(pr.body(), JsonObject.class)).get("Token").getAsString(), refresh, h);
    }

    public static void xstsStep(String xbl, String refresh, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.xsts");
        Request pr = new Request("https://xsts.auth.xboxlive.com/xsts/authorize").header("Content-Type", "application/json").header("Accept", "application/json");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> sub = new HashMap<String, Object>();
        sub.put("SandboxId", "RETAIL");
        sub.put("UserTokens", Arrays.asList(xbl));
        map.put("Properties", sub);
        map.put("RelyingParty", "rp://api.minecraftservices.com/");
        map.put("TokenType", "JWT");
        pr.post(gson.toJson(map));
        if (pr.response() == 401) {
            throw new MicrosoftAuthException(I18n.func_135052_a((String)"ias.msauth.error.noxbox", (Object[])new Object[0]));
        }
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("xsts response: " + pr.response());
        }
        JsonObject jo = (JsonObject)gson.fromJson(pr.body(), JsonObject.class);
        AuthSys.minecraftTokenStep(jo.getAsJsonObject("DisplayClaims").getAsJsonArray("xui").get(0).getAsJsonObject().get("uhs").getAsString(), jo.get("Token").getAsString(), refresh, h);
    }

    public static void minecraftTokenStep(String xbl, String xsts, String refresh, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.mcauth");
        Request pr = new Request("https://api.minecraftservices.com/authentication/login_with_xbox").header("Content-Type", "application/json").header("Accept", "application/json");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("identityToken", "XBL3.0 x=" + xbl + ";" + xsts);
        pr.post(gson.toJson(map));
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("minecraftToken response: " + pr.response());
        }
        AuthSys.minecraftStoreVerify(((JsonObject)gson.fromJson(pr.body(), JsonObject.class)).get("access_token").getAsString(), refresh, h);
    }

    public static void minecraftStoreVerify(String token, String refresh, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.verify");
        Request pr = new Request("https://api.minecraftservices.com/entitlements/mcstore").header("Authorization", "Bearer " + token).get();
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("minecraftStore response: " + pr.response());
        }
        if (((JsonObject)gson.fromJson(pr.body(), JsonObject.class)).getAsJsonArray("items").size() == 0) {
            throw new MicrosoftAuthException(I18n.func_135052_a((String)"ias.msauth.error.gamenotowned", (Object[])new Object[0]));
        }
        AuthSys.minecraftProfileVerify(token, refresh, h);
    }

    public static void minecraftProfileVerify(String token, String refresh, MSAuthHandler h) throws Exception {
        h.setState("ias.msauth.state.profile");
        Request pr = new Request("https://api.minecraftservices.com/minecraft/profile").header("Authorization", "Bearer " + token).get();
        if (pr.response() != 200) {
            throw new MicrosoftAuthException("minecraftProfile response: " + pr.response());
        }
        JsonObject jo = (JsonObject)gson.fromJson(pr.body(), JsonObject.class);
        String name = jo.get("name").getAsString();
        String uuid = jo.get("id").getAsString();
        h.success(name, uuid, token, refresh);
    }

    public static class MicrosoftAuthException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MicrosoftAuthException() {
        }

        public MicrosoftAuthException(String s) {
            super(s);
        }
    }
}

