/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias;

import com.github.mrebhan.ingameaccountswitcher.MR;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import the_fireplace.ias.config.ConfigValues;
import the_fireplace.ias.events.ClientEvents;
import the_fireplace.ias.tools.SkinTools;
import the_fireplace.iasencrypt.Standards;

@Mod(modid="ias", name="In-Game Account Switcher", clientSideOnly=true, guiFactory="the_fireplace.ias.config.IASGuiFactory", updateJSON="https://raw.githubusercontent.com/VidTuGit/In-Game-Account-Switcher/master/updater-forge.json", acceptedMinecraftVersions="1.8.9")
public class IAS {
    public static Properties config = new Properties();

    public static void syncConfig(boolean save) {
        config.setProperty("ias.cfg.casesensitive", String.valueOf(ConfigValues.CASESENSITIVE));
        config.setProperty("ias.cfg.enablerelog", String.valueOf(ConfigValues.ENABLERELOG));
        config.setProperty("ias.cfg.textpos.x", ConfigValues.TEXT_X);
        config.setProperty("ias.cfg.textpos.y", ConfigValues.TEXT_Y);
        config.setProperty("ias.cfg.mpscreen", String.valueOf(ConfigValues.SHOW_ON_MULTIPLAYER_SCREEN));
        if (save) {
            try {
                Minecraft mc = Minecraft.func_71410_x();
                File f = new File(mc.field_71412_D, "config/ias.properties");
                f.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(f);
                config.store(fw, "IAS config");
                fw.close();
            }
            catch (Throwable t) {
                System.err.println("Unable to save IAS config");
                t.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            File f = new File(mc.field_71412_D, "config/ias.properties");
            if (f.exists()) {
                FileReader fr = new FileReader(f);
                config.load(fr);
                fr.close();
            }
            ConfigValues.CASESENSITIVE = Boolean.parseBoolean(config.getProperty("ias.cfg.casesensitive", String.valueOf(false)));
            ConfigValues.ENABLERELOG = Boolean.parseBoolean(config.getProperty("ias.cfg.enablerelog", String.valueOf(false)));
            ConfigValues.TEXT_X = config.getProperty("ias.cfg.textpos.x", "");
            ConfigValues.TEXT_Y = config.getProperty("ias.cfg.textpos.y", "");
            ConfigValues.SHOW_ON_MULTIPLAYER_SCREEN = Boolean.parseBoolean(config.getProperty("ias.cfg.mpscreen", String.valueOf(false)));
        }
        catch (Throwable t) {
            System.err.println("Unable to load IAS config");
            t.printStackTrace();
        }
        IAS.syncConfig(false);
        try {
            Class.forName("net.minecraft.util.MathHelper");
        }
        catch (Throwable t) {
            Standards.updateFolder();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MR.init();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        Standards.importAccounts();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SkinTools.cacheSkins(false);
    }
}

