/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.tools;

import com.github.mrebhan.ingameaccountswitcher.tools.alt.AccountData;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltDatabase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.Display;
import ru.vidtu.iasfork.msauth.MicrosoftAccount;
import the_fireplace.ias.tools.SkinRender;

@SideOnly(value=Side.CLIENT)
public class SkinTools {
    public static final File cachedir = new File(Minecraft.func_71410_x().field_71412_D, "cachedImages/skins/");
    private static final File skinOut = new File(cachedir, "temp.png");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void buildSkin(String name) {
        try {
            File f = new File(cachedir, name + ".png");
            if (!f.exists()) {
                SkinTools.loadFromMojang(Minecraft.func_71410_x(), name, f);
            }
            BufferedImage skin = ImageIO.read(f);
            BufferedImage drawing = new BufferedImage(16, 32, 2);
            if (skin.getHeight() == 64) {
                int i;
                int[] head = skin.getRGB(8, 8, 8, 8, null, 0, 8);
                int[] torso = skin.getRGB(20, 20, 8, 12, null, 0, 8);
                int[] larm = skin.getRGB(44, 20, 4, 12, null, 0, 4);
                int[] rarm = skin.getRGB(36, 52, 4, 12, null, 0, 4);
                int[] lleg = skin.getRGB(4, 20, 4, 12, null, 0, 4);
                int[] rleg = skin.getRGB(20, 52, 4, 12, null, 0, 4);
                int[] hat = skin.getRGB(40, 8, 8, 8, null, 0, 8);
                int[] jacket = skin.getRGB(20, 36, 8, 12, null, 0, 8);
                int[] larm2 = skin.getRGB(44, 36, 4, 12, null, 0, 4);
                int[] rarm2 = skin.getRGB(52, 52, 4, 12, null, 0, 4);
                int[] lleg2 = skin.getRGB(4, 36, 4, 12, null, 0, 4);
                int[] rleg2 = skin.getRGB(4, 52, 4, 12, null, 0, 4);
                for (i = 0; i < hat.length; ++i) {
                    if (new Color(hat[i], true).getAlpha() != 0) continue;
                    hat[i] = head[i];
                }
                for (i = 0; i < jacket.length; ++i) {
                    if (new Color(jacket[i], true).getAlpha() != 0) continue;
                    jacket[i] = torso[i];
                }
                for (i = 0; i < larm2.length; ++i) {
                    if (new Color(larm2[i], true).getAlpha() != 0) continue;
                    larm2[i] = larm[i];
                }
                for (i = 0; i < rarm2.length; ++i) {
                    if (new Color(rarm2[i], true).getAlpha() != 0) continue;
                    rarm2[i] = rarm[i];
                }
                for (i = 0; i < lleg2.length; ++i) {
                    if (new Color(lleg2[i], true).getAlpha() != 0) continue;
                    lleg2[i] = lleg[i];
                }
                for (i = 0; i < rleg2.length; ++i) {
                    if (new Color(rleg2[i], true).getAlpha() != 0) continue;
                    rleg2[i] = rleg[i];
                }
                drawing.setRGB(4, 0, 8, 8, hat, 0, 8);
                drawing.setRGB(4, 8, 8, 12, jacket, 0, 8);
                drawing.setRGB(0, 8, 4, 12, larm2, 0, 4);
                drawing.setRGB(12, 8, 4, 12, rarm2, 0, 4);
                drawing.setRGB(4, 20, 4, 12, lleg2, 0, 4);
                drawing.setRGB(8, 20, 4, 12, rleg2, 0, 4);
            } else {
                int[] head = skin.getRGB(8, 8, 8, 8, null, 0, 8);
                int[] torso = skin.getRGB(20, 20, 8, 12, null, 0, 8);
                int[] arm = skin.getRGB(44, 20, 4, 12, null, 0, 4);
                int[] leg = skin.getRGB(4, 20, 4, 12, null, 0, 4);
                int[] hat = skin.getRGB(40, 8, 8, 8, null, 0, 8);
                for (int i = 0; i < hat.length; ++i) {
                    if (new Color(hat[i], true).getAlpha() != 0) continue;
                    hat[i] = head[i];
                }
                drawing.setRGB(4, 0, 8, 8, hat, 0, 8);
                drawing.setRGB(4, 8, 8, 12, torso, 0, 8);
                drawing.setRGB(0, 8, 4, 12, arm, 0, 4);
                drawing.setRGB(12, 8, 4, 12, arm, 0, 4);
                drawing.setRGB(4, 20, 4, 12, leg, 0, 4);
                drawing.setRGB(8, 20, 4, 12, leg, 0, 4);
            }
            ImageIO.write((RenderedImage)drawing, "png", skinOut);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (skinOut.exists()) {
                skinOut.delete();
            }
            return;
        }
    }

    public static void javDrawSkin(int x, int y, int width, int height) {
        if (!skinOut.exists()) {
            return;
        }
        SkinRender r = new SkinRender(Minecraft.func_71410_x().func_110434_K(), skinOut);
        r.drawImage(x, y, width, height);
    }

    public static void cacheSkins(boolean force) {
        File file;
        Serializable data;
        int i;
        if (!cachedir.exists() && !cachedir.mkdirs()) {
            System.err.println("unable to load cachedir");
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        for (i = 0; i < AltDatabase.getInstance().getAlts().size(); ++i) {
            data = AltDatabase.getInstance().getAlts().get(i);
            Display.setTitle((String)("Minecraft 1.8.9 (IAS: Updating skin " + ((AccountData)data).alias + "...)"));
            file = new File(cachedir, ((AccountData)data).alias + ".png");
            if (!force && file.exists()) continue;
            SkinTools.loadFromMojang(mc, ((AccountData)data).alias, file);
        }
        for (i = 0; i < MicrosoftAccount.msaccounts.size(); ++i) {
            data = MicrosoftAccount.msaccounts.get(i);
            Display.setTitle((String)("Minecraft 1.8.9 (IAS: Updating skin " + ((MicrosoftAccount)data).alias() + "...)"));
            file = new File(cachedir, ((MicrosoftAccount)data).alias() + ".png");
            if (!force && file.exists()) continue;
            SkinTools.loadFromMojang(mc, ((MicrosoftAccount)data).alias(), file);
        }
        Display.setTitle((String)"Minecraft 1.8.9");
    }

    public static void loadFromMojang(Minecraft mc, String name, File f) {
        try {
            InputStream is = new URL("https://api.mojang.com/users/profiles/minecraft/" + name).openStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            String uuid = ((JsonObject)GSON.fromJson((Reader)isr, JsonObject.class)).get("id").getAsString();
            isr.close();
            is.close();
            is = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid).openStream();
            isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            String s = ((JsonObject)GSON.fromJson((Reader)isr, JsonObject.class)).get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
            isr.close();
            is.close();
            is = new URL(((JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8), JsonObject.class)).get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString()).openStream();
            if (f.exists()) {
                f.delete();
            }
            Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            is.close();
        }
        catch (Exception ign) {
            try {
                InputStream is = mc.func_110442_L().func_110536_a(new ResourceLocation("textures/entity/steve.png")).func_110527_b();
                Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                is.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

