/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.sk1eroldanimations.asm;

import club.sk1er.mods.sk1eroldanimations.tweaker.transformer.ITransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemRendererTransformer
implements ITransformer {
    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.ItemRenderer"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode methodNode : classNode.methods) {
            String methodName;
            switch (methodName = this.mapMethodName(classNode, methodNode)) {
                case "transformFirstPersonItem": 
                case "func_178096_b": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.doOldTransformations());
                    break;
                }
                case "performDrinking": 
                case "func_178104_a": {
                    methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.doOldDrinking());
                    break;
                }
                case "renderItemInFirstPerson": 
                case "func_78440_a": {
                    int f1Index = -1;
                    int fIndex = -1;
                    for (LocalVariableNode variableNode : methodNode.localVariables) {
                        switch (variableNode.name) {
                            case "f1": 
                            case "var4": {
                                f1Index = variableNode.index;
                                break;
                            }
                            case "f": 
                            case "var2": {
                                fIndex = variableNode.index;
                            }
                        }
                    }
                    for (AbstractInsnNode node : methodNode.instructions) {
                        String nodeName;
                        if (node.getOpcode() == 183) {
                            switch (nodeName = this.mapMethodNameFromNode(node)) {
                                case "doBowTransformations": 
                                case "func_178098_a": {
                                    int i;
                                    LabelNode labelNode = new LabelNode();
                                    AbstractInsnNode start = node;
                                    for (i = 0; i < 7; ++i) {
                                        start = start.getPrevious();
                                    }
                                    methodNode.instructions.insertBefore(start, this.swingProgressIfNecessary(labelNode, f1Index));
                                    methodNode.instructions.insert(start, (AbstractInsnNode)labelNode);
                                    methodNode.instructions.insert(node, this.moveIfOldBow());
                                    break;
                                }
                                case "performDrinking": 
                                case "func_178104_a": {
                                    int i;
                                    LabelNode veryEnd = new LabelNode();
                                    AbstractInsnNode endNode = node;
                                    for (i = 0; i < 6; ++i) {
                                        endNode = endNode.getNext();
                                    }
                                    methodNode.instructions.insert(node, this.moveIfOldEat(veryEnd, fIndex, f1Index));
                                    methodNode.instructions.insert(endNode, (AbstractInsnNode)veryEnd);
                                    break;
                                }
                                case "doBlockTransformations": 
                                case "func_178103_d": {
                                    AbstractInsnNode start = node;
                                    for (int i = 0; i < 5; ++i) {
                                        start = start.getPrevious();
                                    }
                                    LabelNode labelNode = new LabelNode();
                                    methodNode.instructions.insertBefore(start, this.blockhitSwingProgressIfNecessary(labelNode, f1Index));
                                    methodNode.instructions.insert(start, (AbstractInsnNode)labelNode);
                                    methodNode.instructions.insert(node, this.moveIfBlocking());
                                    break;
                                }
                            }
                            continue;
                        }
                        if (node.getOpcode() != 182 || !(nodeName = this.mapMethodNameFromNode(node)).equals("func_71052_bv") && !nodeName.equals("getItemInUseCount")) continue;
                        AbstractInsnNode pos = node.getNext().getNext().getNext().getNext();
                        methodNode.instructions.insertBefore(pos, (AbstractInsnNode)new MethodInsnNode(184, this.getHookClass(), "swingIfNecessary", "()V", false));
                    }
                    break;
                }
            }
        }
    }

    private InsnList doOldTransformations() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/ItemRenderer", "field_78453_b", "Lnet/minecraft/item/ItemStack;"));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.getHookClass(), "doOldItemTransformation", "(Lnet/minecraft/item/ItemStack;)V", false));
        return list;
    }

    public InsnList doOldDrinking() {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "oldEating", "Z"));
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new VarInsnNode(25, 1));
        list.add((AbstractInsnNode)new VarInsnNode(23, 2));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/ItemRenderer", "field_78453_b", "Lnet/minecraft/item/ItemStack;"));
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.getHookClass(), "doOldEat", "(Lnet/minecraft/client/entity/AbstractClientPlayer;FLnet/minecraft/item/ItemStack;)V", false));
        list.add((AbstractInsnNode)new InsnNode(177));
        list.add((AbstractInsnNode)after);
        return list;
    }

    public InsnList swingProgressIfNecessary(LabelNode labelNode, int f1Index) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "punching", "Z"));
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new VarInsnNode(23, f1Index));
        list.add((AbstractInsnNode)new JumpInsnNode(167, labelNode));
        list.add((AbstractInsnNode)after);
        return list;
    }

    public InsnList blockhitSwingProgressIfNecessary(LabelNode labelNode, int f1Index) {
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "oldBlockhitting", "Z"));
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "punching", "Z"));
        list.add((AbstractInsnNode)new InsnNode(128));
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new VarInsnNode(23, f1Index));
        list.add((AbstractInsnNode)new JumpInsnNode(167, labelNode));
        list.add((AbstractInsnNode)after);
        return list;
    }

    public InsnList moveIfOldBow() {
        InsnList list = new InsnList();
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "oldBowPosition", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.0f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.1f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(-0.15f)));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/GlStateManager", "func_179109_b", "(FFF)V", false));
        list.add((AbstractInsnNode)after);
        return list;
    }

    public InsnList moveIfOldEat(LabelNode veryEnd, int fIndex, int f1Index) {
        InsnList list = new InsnList();
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "punching", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        list.add((AbstractInsnNode)new VarInsnNode(23, fIndex));
        list.add((AbstractInsnNode)new VarInsnNode(23, f1Index));
        list.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/client/renderer/ItemRenderer", "func_178096_b", "(FF)V", false));
        list.add((AbstractInsnNode)new JumpInsnNode(167, veryEnd));
        list.add((AbstractInsnNode)after);
        return list;
    }

    public InsnList moveIfBlocking() {
        InsnList list = new InsnList();
        LabelNode after = new LabelNode();
        list.add((AbstractInsnNode)new FieldInsnNode(178, this.getConfigClass(), "oldBlockhitting", "Z"));
        list.add((AbstractInsnNode)new JumpInsnNode(153, after));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(-0.3f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.1f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.0f)));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/GlStateManager", "func_179109_b", "(FFF)V", false));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.83f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.88f)));
        list.add((AbstractInsnNode)new LdcInsnNode((Object)Float.valueOf(0.85f)));
        list.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/GlStateManager", "func_179152_a", "(FFF)V", false));
        list.add((AbstractInsnNode)after);
        return list;
    }
}

