/*
 * Decompiled with CFR 0.152.
 */
package me.djtheredstoner.perspectivemod.asm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import me.djtheredstoner.perspectivemod.asm.ITransformer;
import me.djtheredstoner.perspectivemod.asm.transformers.ActiveRenderInfoTransformer;
import me.djtheredstoner.perspectivemod.asm.transformers.EntityRendererTransformer;
import me.djtheredstoner.perspectivemod.asm.transformers.MinecraftTransformer;
import me.djtheredstoner.perspectivemod.asm.transformers.RenderManagerTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class ClassTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Perspective Mod v4 Transformer");
    private final Multimap<String, ITransformer> transformerMap = ArrayListMultimap.create();
    public static final boolean outputBytecode = Boolean.parseBoolean(System.getProperty("debugBytecode", "false"));

    public ClassTransformer() {
        this.registerTransformer(new EntityRendererTransformer());
        this.registerTransformer(new RenderManagerTransformer());
        this.registerTransformer(new MinecraftTransformer());
        this.registerTransformer(new ActiveRenderInfoTransformer());
    }

    private void registerTransformer(ITransformer transformer) {
        for (String cls : transformer.getClassName()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 8);
        for (ITransformer transformer : transformers) {
            transformer.transform(node, transformedName);
        }
        ClassWriter writer = new ClassWriter(2);
        try {
            node.accept((ClassVisitor)writer);
        }
        catch (Throwable t) {
            LOGGER.error("Exception when transforming " + transformedName + " : " + t.getClass().getSimpleName());
            t.printStackTrace();
        }
        if (outputBytecode) {
            File bytecodeDirectory = new File("bytecode");
            String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
            if (!bytecodeDirectory.exists()) {
                bytecodeDirectory.mkdirs();
            }
            File bytecodeOutput = new File(bytecodeDirectory, transformedClassName);
            try {
                if (!bytecodeOutput.exists()) {
                    bytecodeOutput.createNewFile();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                os.write(writer.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return writer.toByteArray();
    }
}

