/*
 * Decompiled with CFR 0.152.
 */
package me.djtheredstoner.perspectivemod.asm.transformers;

import me.djtheredstoner.perspectivemod.asm.ITransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ActiveRenderInfoTransformer
implements ITransformer {
    private static final String HOOK_CLASS = "me/djtheredstoner/perspectivemod/asm/hooks/ActiveRenderInfoHook";

    @Override
    public String[] getClassName() {
        return new String[]{"net.minecraft.client.renderer.ActiveRenderInfo"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            String methodName = this.mapMethodName(classNode, method);
            if (!methodName.equals("updateRenderInfo") && !methodName.equals("func_74583_a")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (next.getOpcode() != 180) continue;
                FieldInsnNode insn = (FieldInsnNode)next;
                String ownerName = this.mapClassName(insn.owner);
                String fieldName = this.mapClassName(insn.name);
                if (!ownerName.equals("net/minecraft/entity/player/EntityPlayer") || !insn.desc.equals("F")) continue;
                InsnList insnList = null;
                switch (fieldName) {
                    case "rotationPitch": 
                    case "field_70125_A": {
                        insnList = this.insertRotationHook("Pitch");
                        break;
                    }
                    case "rotationYaw": 
                    case "field_70177_z": {
                        insnList = this.insertRotationHook("Yaw");
                    }
                }
                if (insnList == null) continue;
                method.instructions.insertBefore((AbstractInsnNode)insn, insnList);
                method.instructions.remove((AbstractInsnNode)insn);
            }
        }
    }

    private InsnList insertRotationHook(String field) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, HOOK_CLASS, "rotation" + field + "Hook", "(Lnet/minecraft/entity/player/EntityPlayer;)F", false));
        return insnList;
    }
}

